/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.ParameterInfo;
import cool.scx.reflect.ReflectSupport;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

final class ConstructorInfoImpl
implements ConstructorInfo {
    private final Constructor<?> rawConstructor;
    private final ClassInfo declaringClass;
    private final AccessModifier accessModifier;
    private final ParameterInfo[] parameters;

    ConstructorInfoImpl(Constructor<?> constructor, ClassInfo declaringClass) {
        this.rawConstructor = constructor;
        this.declaringClass = declaringClass;
        Set<AccessFlag> accessFlags = this.rawConstructor.accessFlags();
        this.accessModifier = ReflectSupport._findAccessModifier(accessFlags);
        this.parameters = ReflectSupport._findParameters(this.rawConstructor, this);
    }

    @Override
    public Constructor<?> rawConstructor() {
        return this.rawConstructor;
    }

    @Override
    public ClassInfo declaringClass() {
        return this.declaringClass;
    }

    @Override
    public AccessModifier accessModifier() {
        return this.accessModifier;
    }

    @Override
    public ParameterInfo[] parameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.accessModifier.name().toLowerCase());
        sb.append(" ");
        sb.append(this.declaringClass.rawClass().getSimpleName());
        sb.append("(");
        List<String> paramsStr = Arrays.stream(this.parameters).map(Object::toString).toList();
        sb.append(String.join((CharSequence)", ", paramsStr));
        sb.append(")");
        return sb.toString();
    }
}

