/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassKind;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.ConstructorInfoImpl;
import cool.scx.reflect.ExecutableInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.FieldInfoImpl;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.MethodInfoImpl;
import cool.scx.reflect.ParameterInfo;
import cool.scx.reflect.ParameterInfoImpl;
import cool.scx.reflect.ScxReflect;
import cool.scx.reflect.TypeBindings;
import cool.scx.reflect.TypeBindingsImpl;
import cool.scx.reflect.TypeInfo;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

final class ReflectSupport {
    ReflectSupport() {
    }

    public static TypeInfo _findComponentType(Type type, TypeBindings bindings) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        Object componentType = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, GenericArrayType.class}, (Type)type3, n)) {
            case 0 -> {
                Class c = (Class)type3;
                yield c.componentType();
            }
            case 1 -> {
                GenericArrayType g = (GenericArrayType)type3;
                yield g.getGenericComponentType();
            }
            default -> throw new IllegalArgumentException("unsupported type: " + String.valueOf(type));
        };
        return ScxReflect.getType((Type)componentType, bindings);
    }

    public static Class<?> _findArrayRawClass(Type type, TypeInfo componentType) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, GenericArrayType.class}, (Type)type3, n)) {
            case 0 -> {
                Class<?> c;
                yield c = (Class<?>)type3;
            }
            case 1 -> {
                GenericArrayType g = (GenericArrayType)type3;
                yield Array.newInstance(componentType.rawClass(), 0).getClass();
            }
            default -> throw new IllegalArgumentException("unsupported type: " + String.valueOf(type));
        };
    }

    public static Class<?> _findRawClass(Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, ParameterizedType.class}, (Type)type3, n)) {
            case 0 -> {
                Class c;
                yield c = (Class)type3;
            }
            case 1 -> {
                ParameterizedType p = (ParameterizedType)type3;
                yield (Class)p.getRawType();
            }
            default -> throw new IllegalArgumentException("unsupported type: " + String.valueOf(type));
        };
    }

    public static TypeBindings _findBindings(Type type, TypeBindings bindings) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, ParameterizedType.class}, (Type)type3, n)) {
            case 0: {
                return TypeBindingsImpl.EMPTY_BINDINGS;
            }
            case 1: {
                ParameterizedType p = (ParameterizedType)type3;
                TypeVariable<Class<T>>[] typeVariables = ((Class)p.getRawType()).getTypeParameters();
                Type[] actualTypeArguments = p.getActualTypeArguments();
                TypeInfo[] typeInfos = new TypeInfo[actualTypeArguments.length];
                for (int i = 0; i < actualTypeArguments.length; ++i) {
                    TypeInfo typeInfo;
                    Type actualTypeArgument = actualTypeArguments[i];
                    typeInfos[i] = typeInfo = ScxReflect.getType(actualTypeArgument, bindings);
                }
                return new TypeBindingsImpl(typeVariables, typeInfos);
            }
        }
        throw new IllegalArgumentException("unsupported type: " + String.valueOf(type));
    }

    public static AccessModifier _findAccessModifier(Set<AccessFlag> accessFlags) {
        if (accessFlags.contains((Object)AccessFlag.PUBLIC)) {
            return AccessModifier.PUBLIC;
        }
        if (accessFlags.contains((Object)AccessFlag.PROTECTED)) {
            return AccessModifier.PROTECTED;
        }
        if (accessFlags.contains((Object)AccessFlag.PRIVATE)) {
            return AccessModifier.PRIVATE;
        }
        return AccessModifier.PACKAGE_PRIVATE;
    }

    public static ClassKind _findClassKind(Class<?> rawClass, Set<AccessFlag> accessFlags) {
        if (accessFlags.contains((Object)AccessFlag.ANNOTATION)) {
            return ClassKind.ANNOTATION;
        }
        if (accessFlags.contains((Object)AccessFlag.INTERFACE)) {
            return ClassKind.INTERFACE;
        }
        if (accessFlags.contains((Object)AccessFlag.ENUM)) {
            return ClassKind.ENUM;
        }
        if (rawClass.isRecord()) {
            return ClassKind.RECORD;
        }
        return ClassKind.CLASS;
    }

    public static ClassInfo _findSuperClass(Class<?> rawClass, TypeBindings bindings) {
        Type superClass = rawClass.getGenericSuperclass();
        return superClass != null ? (ClassInfo)ScxReflect.getType(superClass, bindings) : null;
    }

    public static ClassInfo[] _findInterfaces(Class<?> rawClass, TypeBindings bindings) {
        Type[] interfaces = rawClass.getGenericInterfaces();
        ClassInfo[] result = new ClassInfo[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            result[i] = (ClassInfo)ScxReflect.getType(interfaces[i], bindings);
        }
        return result;
    }

    public static ConstructorInfo[] _findConstructors(Class<?> rawClass, ClassInfo classInfo) {
        Constructor<?>[] constructors = rawClass.getDeclaredConstructors();
        ConstructorInfo[] result = new ConstructorInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            result[i] = new ConstructorInfoImpl(constructors[i], classInfo);
        }
        return result;
    }

    public static FieldInfo[] _findFields(Class<?> rawClass, ClassInfo classInfo) {
        Field[] fields = rawClass.getDeclaredFields();
        FieldInfo[] result = new FieldInfo[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = new FieldInfoImpl(fields[i], classInfo);
        }
        return result;
    }

    public static MethodInfo[] _findMethods(Class<?> rawClass, ClassInfo classInfo) {
        Method[] methods = rawClass.getDeclaredMethods();
        ArrayList<MethodInfoImpl> list = new ArrayList<MethodInfoImpl>();
        for (Method method : methods) {
            if (method.isBridge()) continue;
            list.add(new MethodInfoImpl(method, classInfo));
        }
        return (MethodInfo[])list.toArray(MethodInfo[]::new);
    }

    public static ClassInfo[] _findAllSuperClasses(ClassInfo classInfo) {
        ArrayList<ClassInfo> allSuperClasses = new ArrayList<ClassInfo>();
        for (ClassInfo superClass = classInfo.superClass(); superClass != null; superClass = superClass.superClass()) {
            allSuperClasses.add(superClass);
        }
        return (ClassInfo[])allSuperClasses.toArray(ClassInfo[]::new);
    }

    public static ClassInfo[] _findAllInterfaces(ClassInfo classInfo) {
        LinkedHashSet<ClassInfo> result = new LinkedHashSet<ClassInfo>();
        ClassInfo[] interfaces = classInfo.interfaces();
        Collections.addAll(result, interfaces);
        ClassInfo[][] temp = new ClassInfo[interfaces.length][];
        int maxDepth = 0;
        for (int i = 0; i < interfaces.length; ++i) {
            temp[i] = interfaces[i].allInterfaces();
            if (temp[i].length <= maxDepth) continue;
            maxDepth = temp[i].length;
        }
        for (int level = 0; level < maxDepth; ++level) {
            for (ClassInfo[] classInfos : temp) {
                if (level >= classInfos.length) continue;
                result.add(classInfos[level]);
            }
        }
        return (ClassInfo[])result.toArray(ClassInfo[]::new);
    }

    public static ParameterInfo[] _findParameters(Executable rawExecutable, ExecutableInfo executableInfo) {
        Parameter[] parameters = rawExecutable.getParameters();
        ParameterInfo[] result = new ParameterInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            result[i] = new ParameterInfoImpl(parameters[i], executableInfo);
        }
        return result;
    }

    public static ConstructorInfo _findDefaultConstructor(ClassInfo classInfo) {
        for (ConstructorInfo constructor : classInfo.constructors()) {
            if (constructor.parameters().length != 0) continue;
            return constructor;
        }
        return null;
    }

    public static ConstructorInfo _findRecordConstructor(ClassInfo classInfo) {
        if (classInfo.classKind() != ClassKind.RECORD) {
            return null;
        }
        TypeInfo[] recordComponentTypes = ReflectSupport._getRecordComponentsTypes(classInfo);
        for (ConstructorInfo constructor : classInfo.constructors()) {
            boolean matched = ReflectSupport._hasSameParameterTypes(constructor, recordComponentTypes);
            if (!matched) continue;
            return constructor;
        }
        return null;
    }

    private static TypeInfo[] _getRecordComponentsTypes(ClassInfo classInfo) {
        RecordComponent[] recordComponents = classInfo.rawClass().getRecordComponents();
        TypeInfo[] result = new TypeInfo[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            result[i] = ScxReflect.getType(recordComponents[i].getGenericType(), classInfo.bindings());
        }
        return result;
    }

    private static boolean _hasSameParameterTypes(ExecutableInfo constructorInfo, TypeInfo[] types) {
        if (constructorInfo.parameters().length != types.length) {
            return false;
        }
        ParameterInfo[] p1 = constructorInfo.parameters();
        for (int i = 0; i < p1.length; ++i) {
            TypeInfo p2Type;
            TypeInfo p1Type = p1[i].parameterType();
            if (p1Type == (p2Type = types[i])) continue;
            return false;
        }
        return true;
    }

    public static FieldInfo[] _findAllFields(ClassInfo classInfo) {
        ArrayList allFieldInfos = new ArrayList();
        Collections.addAll(allFieldInfos, classInfo.fields());
        ClassInfo superClass = classInfo.superClass();
        if (superClass != null) {
            Collections.addAll(allFieldInfos, superClass.allFields());
        }
        return (FieldInfo[])allFieldInfos.toArray(FieldInfo[]::new);
    }

    public static MethodInfo _findSuperMethod(MethodInfo methodInfo) {
        if (methodInfo.isStatic()) {
            return null;
        }
        for (ClassInfo i : methodInfo.declaringClass().allSuperClasses()) {
            for (MethodInfo superMethod : i.methods()) {
                if (superMethod.isStatic() || superMethod.isFinal() || !ReflectSupport.isOverride(methodInfo, superMethod)) continue;
                return superMethod;
            }
        }
        for (ClassInfo i : methodInfo.declaringClass().allInterfaces()) {
            for (MethodInfo superMethod : i.methods()) {
                if (superMethod.isStatic() || superMethod.isFinal() || !ReflectSupport.isOverride(methodInfo, superMethod)) continue;
                return superMethod;
            }
        }
        return null;
    }

    public static MethodInfo[] _findAllMethods(ClassInfo classInfo) {
        ClassInfo[] interfaces;
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        HashSet<MethodInfo> overridden = new HashSet<MethodInfo>();
        for (MethodInfo method : classInfo.methods()) {
            result.add(method);
            if (method.superMethod() == null) continue;
            overridden.add(method.superMethod());
        }
        ClassInfo superClass = classInfo.superClass();
        if (superClass != null) {
            for (MethodInfo m : superClass.allMethods()) {
                if (overridden.contains(m)) continue;
                result.add(m);
            }
        }
        for (ClassInfo i : interfaces = classInfo.interfaces()) {
            for (MethodInfo m : i.allMethods()) {
                if (overridden.contains(m)) continue;
                result.add(m);
            }
        }
        return (MethodInfo[])result.toArray(MethodInfo[]::new);
    }

    public static ClassInfo _findEnumClass(ClassInfo classInfo) {
        if (classInfo.classKind() == ClassKind.ENUM) {
            return classInfo.isAnonymousClass() ? classInfo.superClass() : classInfo;
        }
        return null;
    }

    private static boolean isOverride(MethodInfo methodInfo, MethodInfo superMethod) {
        String p2;
        String p1;
        if (superMethod.accessModifier() == AccessModifier.PRIVATE) {
            return false;
        }
        if (superMethod.accessModifier() == AccessModifier.PACKAGE_PRIVATE && !(p1 = superMethod.declaringClass().rawClass().getPackageName()).equals(p2 = methodInfo.declaringClass().rawClass().getPackageName())) {
            return false;
        }
        if (!superMethod.name().equals(methodInfo.name())) {
            return false;
        }
        return ReflectSupport._hasSameParameterErasedTypes(methodInfo, superMethod);
    }

    private static boolean _hasSameParameterErasedTypes(ExecutableInfo rootMethod, ExecutableInfo candidateMethod) {
        if (candidateMethod.parameters().length != rootMethod.parameters().length) {
            return false;
        }
        ParameterInfo[] p1 = rootMethod.parameters();
        ParameterInfo[] p2 = candidateMethod.parameters();
        for (int i = 0; i < p1.length; ++i) {
            TypeInfo p1Type = p1[i].parameterType();
            TypeInfo p2Type = p2[i].parameterType();
            if (p1Type.rawClass() == p2Type.rawClass()) continue;
            return false;
        }
        return true;
    }
}

