/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.ParameterInfo;
import cool.scx.reflect.ReflectSupport;
import cool.scx.reflect.ScxReflect;
import cool.scx.reflect.TypeInfo;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

final class MethodInfoImpl
implements MethodInfo {
    private final Method rawMethod;
    private final ClassInfo declaringClass;
    private final String name;
    private final AccessModifier accessModifier;
    private final boolean isAbstract;
    private final boolean isFinal;
    private final boolean isStatic;
    private final boolean isNative;
    private final boolean isDefault;
    private final ParameterInfo[] parameters;
    private final TypeInfo returnType;
    private boolean superMethodLoaded;
    private MethodInfo superMethod;

    MethodInfoImpl(Method method, ClassInfo declaringClass) {
        this.rawMethod = method;
        this.declaringClass = declaringClass;
        this.name = this.rawMethod.getName();
        Set<AccessFlag> accessFlags = this.rawMethod.accessFlags();
        this.accessModifier = ReflectSupport._findAccessModifier(accessFlags);
        this.isAbstract = accessFlags.contains((Object)AccessFlag.ABSTRACT);
        this.isFinal = accessFlags.contains((Object)AccessFlag.FINAL);
        this.isStatic = accessFlags.contains((Object)AccessFlag.STATIC);
        this.isNative = accessFlags.contains((Object)AccessFlag.NATIVE);
        this.isDefault = this.rawMethod.isDefault();
        this.parameters = ReflectSupport._findParameters(this.rawMethod, this);
        this.returnType = ScxReflect.getType(this.rawMethod.getGenericReturnType(), this.declaringClass.bindings());
    }

    @Override
    public Method rawMethod() {
        return this.rawMethod;
    }

    @Override
    public ClassInfo declaringClass() {
        return this.declaringClass;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public AccessModifier accessModifier() {
        return this.accessModifier;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public boolean isNative() {
        return this.isNative;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public ParameterInfo[] parameters() {
        return (ParameterInfo[])this.parameters.clone();
    }

    @Override
    public TypeInfo returnType() {
        return this.returnType;
    }

    @Override
    public MethodInfo superMethod() {
        if (!this.superMethodLoaded) {
            this.superMethod = ReflectSupport._findSuperMethod(this);
            this.superMethodLoaded = true;
        }
        return this.superMethod;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.accessModifier.name().toLowerCase());
        if (this.isDefault) {
            sb.append(" default");
        }
        if (this.isStatic) {
            sb.append(" static");
        }
        if (this.isAbstract) {
            sb.append(" abstract");
        }
        if (this.isFinal) {
            sb.append(" final");
        }
        sb.append(" ").append(this.returnType.toString());
        sb.append(" ").append(this.name);
        sb.append("(");
        List<String> paramsStr = Arrays.stream(this.parameters).map(Object::toString).toList();
        sb.append(String.join((CharSequence)", ", paramsStr));
        sb.append(")");
        return sb.toString();
    }
}

