/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassKind;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.RecordComponentInfo;
import cool.scx.reflect.ReflectSupport;
import cool.scx.reflect.ScxReflect;
import cool.scx.reflect.TypeBindings;
import cool.scx.reflect.TypeInfo;
import cool.scx.reflect.TypeKey;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

final class ClassInfoImpl
implements ClassInfo {
    private final Class<?> rawClass;
    private final TypeBindings bindings;
    private final String name;
    private final AccessModifier accessModifier;
    private final ClassKind classKind;
    private final boolean isAbstract;
    private final boolean isFinal;
    private final boolean isStatic;
    private final boolean isAnonymousClass;
    private final boolean isMemberClass;
    private boolean superClassLoaded;
    private ClassInfo superClass;
    private ClassInfo[] interfaces;
    private ConstructorInfo[] constructors;
    private FieldInfo[] fields;
    private MethodInfo[] methods;
    private ClassInfo[] allSuperClasses;
    private ClassInfo[] allInterfaces;
    private boolean defaultConstructorLoaded;
    private ConstructorInfo defaultConstructor;
    private boolean recordConstructorLoaded;
    private ConstructorInfo recordConstructor;
    private FieldInfo[] allFields;
    private MethodInfo[] allMethods;
    private ClassInfo enumClass;
    private RecordComponentInfo[] recordComponents;

    ClassInfoImpl(Type type, TypeBindings bindings) {
        ScxReflect.TYPE_CACHE.put(TypeKey.createTypeKey(type, bindings), this);
        this.rawClass = ReflectSupport._findRawClass(type);
        this.bindings = ReflectSupport._findBindings(type, bindings);
        this.name = this.rawClass.getName();
        Set<AccessFlag> accessFlags = this.rawClass.accessFlags();
        this.accessModifier = ReflectSupport._findAccessModifier(accessFlags);
        this.classKind = ReflectSupport._findClassKind(this.rawClass, accessFlags);
        this.isAbstract = accessFlags.contains((Object)AccessFlag.ABSTRACT);
        this.isFinal = accessFlags.contains((Object)AccessFlag.FINAL);
        this.isStatic = accessFlags.contains((Object)AccessFlag.STATIC);
        this.isAnonymousClass = this.rawClass.isAnonymousClass();
        this.isMemberClass = this.rawClass.isMemberClass();
    }

    @Override
    public Class<?> rawClass() {
        return this.rawClass;
    }

    @Override
    public TypeBindings bindings() {
        return this.bindings;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public AccessModifier accessModifier() {
        return this.accessModifier;
    }

    @Override
    public ClassKind classKind() {
        return this.classKind;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public boolean isAnonymousClass() {
        return this.isAnonymousClass;
    }

    @Override
    public boolean isMemberClass() {
        return this.isMemberClass;
    }

    @Override
    public ClassInfo superClass() {
        if (!this.superClassLoaded) {
            this.superClass = ReflectSupport._findSuperClass(this.rawClass, this.bindings);
            this.superClassLoaded = true;
        }
        return this.superClass;
    }

    @Override
    public ClassInfo[] interfaces() {
        if (this.interfaces == null) {
            this.interfaces = ReflectSupport._findInterfaces(this.rawClass, this.bindings);
        }
        return (ClassInfo[])this.interfaces.clone();
    }

    @Override
    public ConstructorInfo[] constructors() {
        if (this.constructors == null) {
            this.constructors = ReflectSupport._findConstructors(this.rawClass, this);
        }
        return (ConstructorInfo[])this.constructors.clone();
    }

    @Override
    public FieldInfo[] fields() {
        if (this.fields == null) {
            this.fields = ReflectSupport._findFields(this.rawClass, this);
        }
        return (FieldInfo[])this.fields.clone();
    }

    @Override
    public MethodInfo[] methods() {
        if (this.methods == null) {
            this.methods = ReflectSupport._findMethods(this.rawClass, this);
        }
        return (MethodInfo[])this.methods.clone();
    }

    @Override
    public ClassInfo[] allSuperClasses() {
        if (this.allSuperClasses == null) {
            this.allSuperClasses = ReflectSupport._findAllSuperClasses(this);
        }
        return (ClassInfo[])this.allSuperClasses.clone();
    }

    @Override
    public ClassInfo[] allInterfaces() {
        if (this.allInterfaces == null) {
            this.allInterfaces = ReflectSupport._findAllInterfaces(this);
        }
        return (ClassInfo[])this.allInterfaces.clone();
    }

    @Override
    public ConstructorInfo defaultConstructor() {
        if (!this.defaultConstructorLoaded) {
            this.defaultConstructor = ReflectSupport._findDefaultConstructor(this);
            this.defaultConstructorLoaded = true;
        }
        return this.defaultConstructor;
    }

    @Override
    public ConstructorInfo recordConstructor() {
        if (!this.recordConstructorLoaded) {
            this.recordConstructor = ReflectSupport._findRecordConstructor(this);
            this.recordConstructorLoaded = true;
        }
        return this.recordConstructor;
    }

    @Override
    public FieldInfo[] allFields() {
        if (this.allFields == null) {
            this.allFields = ReflectSupport._findAllFields(this);
        }
        return (FieldInfo[])this.allFields.clone();
    }

    @Override
    public MethodInfo[] allMethods() {
        if (this.allMethods == null) {
            this.allMethods = ReflectSupport._findAllMethods(this);
        }
        return (MethodInfo[])this.allMethods.clone();
    }

    @Override
    public ClassInfo enumClass() {
        if (this.enumClass == null) {
            this.enumClass = ReflectSupport._findEnumClass(this);
        }
        return this.enumClass;
    }

    @Override
    public RecordComponentInfo[] recordComponents() {
        if (this.recordComponents == null) {
            this.recordComponents = ReflectSupport._findRecordComponents(this);
        }
        return (RecordComponentInfo[])this.recordComponents.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ClassInfoImpl) {
            ClassInfoImpl classInfo = (ClassInfoImpl)object;
            return this.rawClass == classInfo.rawClass && this.bindings.equals(classInfo.bindings);
        }
        return false;
    }

    public int hashCode() {
        int result = this.rawClass.hashCode();
        result = 31 * result + this.bindings.hashCode();
        return result;
    }

    public String toString() {
        String shortName = this.rawClass.getSimpleName();
        List<String> typeArgs = Arrays.stream(this.bindings.typeInfos()).map((Function<TypeInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lcool/scx/reflect/TypeInfo;)Ljava/lang/String;)()).toList();
        if (typeArgs.isEmpty()) {
            return shortName;
        }
        return shortName + "<" + String.join((CharSequence)", ", typeArgs) + ">";
    }
}

