/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.ArrayTypeInfoImpl;
import cool.scx.reflect.ClassInfoImpl;
import cool.scx.reflect.PrimitiveTypeInfoImpl;
import cool.scx.reflect.TypeBindings;
import cool.scx.reflect.TypeBindingsImpl;
import cool.scx.reflect.TypeInfo;
import cool.scx.reflect.TypeKey;
import cool.scx.reflect.TypeReference;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;

public final class ScxReflect {
    static final Map<TypeKey, TypeInfo> TYPE_CACHE = new HashMap<TypeKey, TypeInfo>();

    static TypeInfo getType(Type type, TypeBindings bindings) {
        TypeInfo t = TYPE_CACHE.get(TypeKey.createTypeKey(type, bindings));
        if (t != null) {
            return t;
        }
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isArray()) {
                return new ArrayTypeInfoImpl(c, bindings);
            }
            if (c.isPrimitive()) {
                return new PrimitiveTypeInfoImpl(c);
            }
            return new ClassInfoImpl(c, bindings);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return new ClassInfoImpl(p, bindings);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)type;
            return new ArrayTypeInfoImpl(g, bindings);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            TypeInfo typeInfo = bindings.get(typeVariable);
            if (typeInfo != null) {
                return typeInfo;
            }
            return ScxReflect.getType(typeVariable.getBounds()[0], bindings);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return ScxReflect.getType(wildcardType.getUpperBounds()[0], bindings);
        }
        throw new IllegalArgumentException("unsupported type: " + String.valueOf(type));
    }

    public static TypeInfo getType(TypeReference<?> typeReference) {
        return ScxReflect.getType(typeReference.getType());
    }

    public static TypeInfo getType(Type type) {
        return ScxReflect.getType(type, TypeBindingsImpl.EMPTY_BINDINGS);
    }
}

