/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.ArrayTypeInfo;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.PrimitiveTypeInfo;
import cool.scx.reflect.ReflectSupport;
import cool.scx.reflect.TypeBindings;
import cool.scx.reflect.TypeBindingsImpl;
import cool.scx.reflect.TypeInfo;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

final class TypeKey {
    private final Class<?> rawClass;
    private final TypeBindings bindings;

    private TypeKey(Class<?> rawClass, TypeBindings bindings) {
        this.rawClass = rawClass;
        this.bindings = bindings;
    }

    private TypeKey(TypeInfo typeInfo) {
        TypeInfo typeInfo2 = typeInfo;
        Objects.requireNonNull(typeInfo2);
        TypeInfo typeInfo3 = typeInfo2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassInfo.class, ArrayTypeInfo.class, PrimitiveTypeInfo.class}, (TypeInfo)typeInfo3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ClassInfo classInfo = (ClassInfo)typeInfo3;
                this.rawClass = classInfo.rawClass();
                this.bindings = classInfo.bindings();
                break;
            }
            case 1: {
                ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)typeInfo3;
                this.rawClass = arrayTypeInfo.rawClass();
                this.bindings = TypeBindingsImpl.EMPTY_BINDINGS;
                break;
            }
            case 2: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo3;
                this.rawClass = primitiveTypeInfo.rawClass();
                this.bindings = TypeBindingsImpl.EMPTY_BINDINGS;
            }
        }
    }

    public static TypeKey createTypeKey(Type type, TypeBindings bindings) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return new TypeKey(c, TypeBindingsImpl.EMPTY_BINDINGS);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return new TypeKey((Class)p.getRawType(), ReflectSupport._findBindings(type, bindings));
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)type;
            return new TypeKey(ReflectSupport._findArrayRawClass(type, ReflectSupport._findComponentType(g, bindings)), TypeBindingsImpl.EMPTY_BINDINGS);
        }
        if (type instanceof TypeVariable) {
            TypeVariable t = (TypeVariable)type;
            TypeInfo typeInfo = bindings.get(t);
            if (typeInfo != null) {
                return new TypeKey(typeInfo);
            }
            return TypeKey.createTypeKey(t.getBounds()[0], bindings);
        }
        if (type instanceof WildcardType) {
            WildcardType w = (WildcardType)type;
            return TypeKey.createTypeKey(w.getUpperBounds()[0], bindings);
        }
        throw new IllegalArgumentException("unsupported type: " + String.valueOf(type));
    }

    public Type rawClass() {
        return this.rawClass;
    }

    public TypeBindings bindings() {
        return this.bindings;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TypeKey) {
            TypeKey typeKey = (TypeKey)object;
            return this.rawClass == typeKey.rawClass && this.bindings.equals(typeKey.bindings);
        }
        return false;
    }

    public int hashCode() {
        int result = this.rawClass.hashCode();
        result = 31 * result + this.bindings.hashCode();
        return result;
    }

    public String toString() {
        String shortName = this.rawClass.getSimpleName();
        List<String> typeArgs = Arrays.stream(this.bindings.typeInfos()).map((Function<TypeInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lcool/scx/reflect/TypeInfo;)Ljava/lang/String;)()).toList();
        if (typeArgs.isEmpty()) {
            return shortName;
        }
        return shortName + "<" + String.join((CharSequence)", ", typeArgs) + ">";
    }
}

