/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.ArrayTypeInfo;
import cool.scx.reflect.TypeFactory;
import cool.scx.reflect.TypeInfo;
import cool.scx.reflect.TypeResolutionContext;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;

final class ArrayTypeInfoImpl
implements ArrayTypeInfo {
    private final Class<?> rawClass;
    private final TypeInfo componentType;

    ArrayTypeInfoImpl(Class<?> arrayClass) {
        this.rawClass = arrayClass;
        this.componentType = TypeFactory.typeOfClass(this.rawClass.componentType());
    }

    ArrayTypeInfoImpl(GenericArrayType type, TypeResolutionContext context) {
        this.componentType = TypeFactory.typeOfAny(type.getGenericComponentType(), context);
        this.rawClass = Array.newInstance(this.componentType.rawClass(), 0).getClass();
    }

    @Override
    public Class<?> rawClass() {
        return this.rawClass;
    }

    @Override
    public TypeInfo componentType() {
        return this.componentType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ArrayTypeInfoImpl) {
            ArrayTypeInfoImpl that = (ArrayTypeInfoImpl)object;
            return this.componentType.equals(that.componentType);
        }
        return false;
    }

    public int hashCode() {
        int result = ArrayTypeInfoImpl.class.hashCode();
        result = 31 * result + this.componentType.hashCode();
        return result;
    }

    public String toString() {
        return this.componentType.toString() + "[]";
    }
}

