/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.ExecutableInfo;
import cool.scx.reflect.ParameterInfo;
import cool.scx.reflect.TypeFactory;
import cool.scx.reflect.TypeInfo;
import cool.scx.reflect.TypeResolutionContext;
import java.lang.reflect.Parameter;

final class ParameterInfoImpl
implements ParameterInfo {
    private final Parameter rawParameter;
    private final ExecutableInfo declaringExecutable;
    private final String name;
    private final TypeInfo parameterType;

    ParameterInfoImpl(Parameter parameter, ExecutableInfo declaringExecutable) {
        this.rawParameter = parameter;
        this.declaringExecutable = declaringExecutable;
        this.name = this.rawParameter.getName();
        this.parameterType = TypeFactory.typeOfAny(this.rawParameter.getParameterizedType(), new TypeResolutionContext(this.declaringExecutable.declaringClass().bindings()));
    }

    @Override
    public Parameter rawParameter() {
        return this.rawParameter;
    }

    @Override
    public ExecutableInfo declaringExecutable() {
        return this.declaringExecutable;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TypeInfo parameterType() {
        return this.parameterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ParameterInfoImpl) {
            ParameterInfoImpl that = (ParameterInfoImpl)o;
            return this.rawParameter.equals(that.rawParameter);
        }
        return false;
    }

    public int hashCode() {
        int result = ParameterInfoImpl.class.hashCode();
        result = 31 * result + this.rawParameter.hashCode();
        return result;
    }

    public String toString() {
        return this.parameterType.toString() + " " + this.name();
    }
}

