/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.RecordComponentInfo;
import cool.scx.reflect.TypeFactory;
import cool.scx.reflect.TypeInfo;
import cool.scx.reflect.TypeResolutionContext;
import java.lang.reflect.RecordComponent;

final class RecordComponentInfoImpl
implements RecordComponentInfo {
    private final RecordComponent rawRecordComponent;
    private final ClassInfo declaringClass;
    private final String name;
    private final TypeInfo recordComponentType;

    RecordComponentInfoImpl(RecordComponent recordComponent, ClassInfo declaringClass) {
        this.rawRecordComponent = recordComponent;
        this.declaringClass = declaringClass;
        this.name = this.rawRecordComponent.getName();
        this.recordComponentType = TypeFactory.typeOfAny(this.rawRecordComponent.getGenericType(), new TypeResolutionContext(this.declaringClass.bindings()));
    }

    @Override
    public RecordComponent rawRecordComponent() {
        return this.rawRecordComponent;
    }

    @Override
    public ClassInfo declaringClass() {
        return this.declaringClass;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TypeInfo recordComponentType() {
        return this.recordComponentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RecordComponentInfoImpl) {
            RecordComponentInfoImpl that = (RecordComponentInfoImpl)o;
            return this.rawRecordComponent.equals(that.rawRecordComponent);
        }
        return false;
    }

    public int hashCode() {
        int result = RecordComponentInfoImpl.class.hashCode();
        result = 31 * result + this.rawRecordComponent.hashCode();
        return result;
    }

    public String toString() {
        return this.recordComponentType.toString() + " " + this.name;
    }
}

