/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.TypeBindings;
import cool.scx.reflect.TypeInfo;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

final class TypeBindingsImpl
implements TypeBindings {
    public static final TypeBindings EMPTY_BINDINGS = new TypeBindingsImpl(new TypeVariable[0], new TypeInfo[0]);
    private final TypeVariable<?>[] typeVariables;
    private final TypeInfo[] typeInfos;

    TypeBindingsImpl(TypeVariable<?>[] typeVariables, TypeInfo[] typeInfos) {
        this.typeVariables = typeVariables;
        this.typeInfos = typeInfos;
    }

    @Override
    public TypeInfo get(TypeVariable<?> typeVariable) {
        for (int i = 0; i < this.typeVariables.length; ++i) {
            TypeVariable<?> t = this.typeVariables[i];
            if (!t.equals(typeVariable)) continue;
            return this.typeInfos[i];
        }
        return null;
    }

    @Override
    public TypeInfo get(String name) {
        for (int i = 0; i < this.typeVariables.length; ++i) {
            TypeVariable<?> t = this.typeVariables[i];
            if (!t.getName().equals(name)) continue;
            return this.typeInfos[i];
        }
        return null;
    }

    @Override
    public TypeInfo get(int index) {
        if (index >= 0 && index < this.typeInfos.length) {
            return this.typeInfos[index];
        }
        return null;
    }

    @Override
    public TypeVariable<?>[] typeVariables() {
        return (TypeVariable[])this.typeVariables.clone();
    }

    @Override
    public TypeInfo[] typeInfos() {
        return (TypeInfo[])this.typeInfos.clone();
    }

    @Override
    public int size() {
        return this.typeVariables.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<Map.Entry<TypeVariable<?>, TypeInfo>> iterator() {
        return new TypeBindingsIterator(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TypeBindingsImpl) {
            TypeBindingsImpl entries = (TypeBindingsImpl)object;
            return Arrays.equals(this.typeVariables, entries.typeVariables) && Arrays.equals(this.typeInfos, entries.typeInfos);
        }
        return false;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.typeVariables);
        result = 31 * result + Arrays.hashCode(this.typeInfos);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int i = 0; i < this.typeVariables.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.typeVariables[i].getName()).append("=").append(this.typeInfos[i].toString());
        }
        sb.append('}');
        return sb.toString();
    }

    private static final class TypeBindingsIterator
    implements Iterator<Map.Entry<TypeVariable<?>, TypeInfo>> {
        private final TypeBindingsImpl bindings;
        private int index;

        private TypeBindingsIterator(TypeBindingsImpl bindings) {
            this.bindings = bindings;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.bindings.typeVariables.length;
        }

        @Override
        public Map.Entry<TypeVariable<?>, TypeInfo> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TypeVariable<?> key = this.bindings.typeVariables[this.index];
            TypeInfo value = this.bindings.typeInfos[this.index];
            ++this.index;
            return Map.entry(key, value);
        }
    }
}

