/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassKind;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.RecordComponentInfo;
import cool.scx.reflect.ReflectSupport;
import cool.scx.reflect.TypeBindings;
import cool.scx.reflect.TypeBindingsImpl;
import cool.scx.reflect.TypeInfo;
import cool.scx.reflect.TypeResolutionContext;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.ParameterizedType;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class ClassInfoImpl
implements ClassInfo {
    private final Class<?> rawClass;
    private final TypeBindings bindings;
    private final String name;
    private final AccessModifier accessModifier;
    private final ClassKind classKind;
    private final boolean isAbstract;
    private final boolean isFinal;
    private final boolean isStatic;
    private final boolean isAnonymousClass;
    private final boolean isMemberClass;
    private final Lock LOCK;
    private final int hashCode;
    private volatile boolean superClassLoaded;
    private volatile ClassInfo superClass;
    private volatile ClassInfo[] interfaces;
    private volatile ConstructorInfo[] constructors;
    private volatile FieldInfo[] fields;
    private volatile MethodInfo[] methods;
    private volatile ClassInfo[] allSuperClasses;
    private volatile ClassInfo[] allInterfaces;
    private volatile boolean defaultConstructorLoaded;
    private volatile ConstructorInfo defaultConstructor;
    private volatile boolean recordConstructorLoaded;
    private volatile ConstructorInfo recordConstructor;
    private volatile FieldInfo[] allFields;
    private volatile MethodInfo[] allMethods;
    private volatile ClassInfo enumClass;
    private volatile RecordComponentInfo[] recordComponents;

    ClassInfoImpl(Class<?> clazz) {
        this.rawClass = clazz;
        this.bindings = TypeBindingsImpl.EMPTY_BINDINGS;
        this.name = this.rawClass.getName();
        Set<AccessFlag> accessFlags = this.rawClass.accessFlags();
        this.accessModifier = ReflectSupport._findAccessModifier(accessFlags);
        this.classKind = ReflectSupport._findClassKind(this.rawClass, accessFlags);
        this.isAbstract = accessFlags.contains((Object)AccessFlag.ABSTRACT);
        this.isFinal = accessFlags.contains((Object)AccessFlag.FINAL);
        this.isStatic = accessFlags.contains((Object)AccessFlag.STATIC);
        this.isAnonymousClass = this.rawClass.isAnonymousClass();
        this.isMemberClass = this.rawClass.isMemberClass();
        this.LOCK = new ReentrantLock();
        this.hashCode = this._hashCode();
    }

    ClassInfoImpl(ParameterizedType parameterizedType, TypeResolutionContext context) {
        context.inProgressTypes().put(parameterizedType, this);
        this.rawClass = (Class)parameterizedType.getRawType();
        this.bindings = ReflectSupport._findBindings(parameterizedType, context);
        this.name = this.rawClass.getName();
        Set<AccessFlag> accessFlags = this.rawClass.accessFlags();
        this.accessModifier = ReflectSupport._findAccessModifier(accessFlags);
        this.classKind = ReflectSupport._findClassKind(this.rawClass, accessFlags);
        this.isAbstract = accessFlags.contains((Object)AccessFlag.ABSTRACT);
        this.isFinal = accessFlags.contains((Object)AccessFlag.FINAL);
        this.isStatic = accessFlags.contains((Object)AccessFlag.STATIC);
        this.isAnonymousClass = this.rawClass.isAnonymousClass();
        this.isMemberClass = this.rawClass.isMemberClass();
        this.LOCK = new ReentrantLock();
        this.hashCode = this._hashCode();
    }

    @Override
    public Class<?> rawClass() {
        return this.rawClass;
    }

    @Override
    public TypeBindings bindings() {
        return this.bindings;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public AccessModifier accessModifier() {
        return this.accessModifier;
    }

    @Override
    public ClassKind classKind() {
        return this.classKind;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public boolean isAnonymousClass() {
        return this.isAnonymousClass;
    }

    @Override
    public boolean isMemberClass() {
        return this.isMemberClass;
    }

    @Override
    public ClassInfo superClass() {
        if (!this.superClassLoaded) {
            this.LOCK.lock();
            try {
                if (!this.superClassLoaded) {
                    this.superClass = ReflectSupport._findSuperClass(this.rawClass, this.bindings);
                    this.superClassLoaded = true;
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return this.superClass;
    }

    @Override
    public ClassInfo[] interfaces() {
        if (this.interfaces == null) {
            this.LOCK.lock();
            try {
                if (this.interfaces == null) {
                    this.interfaces = ReflectSupport._findInterfaces(this.rawClass, this.bindings);
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return (ClassInfo[])this.interfaces.clone();
    }

    @Override
    public ConstructorInfo[] constructors() {
        if (this.constructors == null) {
            this.LOCK.lock();
            try {
                if (this.constructors == null) {
                    this.constructors = ReflectSupport._findConstructors(this.rawClass, this);
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return (ConstructorInfo[])this.constructors.clone();
    }

    @Override
    public FieldInfo[] fields() {
        if (this.fields == null) {
            this.LOCK.lock();
            try {
                if (this.fields == null) {
                    this.fields = ReflectSupport._findFields(this.rawClass, this);
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return (FieldInfo[])this.fields.clone();
    }

    @Override
    public MethodInfo[] methods() {
        if (this.methods == null) {
            this.LOCK.lock();
            try {
                if (this.methods == null) {
                    this.methods = ReflectSupport._findMethods(this.rawClass, this);
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return (MethodInfo[])this.methods.clone();
    }

    @Override
    public ClassInfo[] allSuperClasses() {
        if (this.allSuperClasses == null) {
            this.LOCK.lock();
            try {
                if (this.allSuperClasses == null) {
                    this.allSuperClasses = ReflectSupport._findAllSuperClasses(this);
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return (ClassInfo[])this.allSuperClasses.clone();
    }

    @Override
    public ClassInfo[] allInterfaces() {
        if (this.allInterfaces == null) {
            this.LOCK.lock();
            try {
                if (this.allInterfaces == null) {
                    this.allInterfaces = ReflectSupport._findAllInterfaces(this);
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return (ClassInfo[])this.allInterfaces.clone();
    }

    @Override
    public ConstructorInfo defaultConstructor() {
        if (!this.defaultConstructorLoaded) {
            this.LOCK.lock();
            try {
                if (!this.defaultConstructorLoaded) {
                    this.defaultConstructor = ReflectSupport._findDefaultConstructor(this);
                    this.defaultConstructorLoaded = true;
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return this.defaultConstructor;
    }

    @Override
    public ConstructorInfo recordConstructor() {
        if (!this.recordConstructorLoaded) {
            this.LOCK.lock();
            try {
                if (!this.recordConstructorLoaded) {
                    this.recordConstructor = ReflectSupport._findRecordConstructor(this);
                    this.recordConstructorLoaded = true;
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return this.recordConstructor;
    }

    @Override
    public FieldInfo[] allFields() {
        if (this.allFields == null) {
            this.LOCK.lock();
            try {
                if (this.allFields == null) {
                    this.allFields = ReflectSupport._findAllFields(this);
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return (FieldInfo[])this.allFields.clone();
    }

    @Override
    public MethodInfo[] allMethods() {
        if (this.allMethods == null) {
            this.LOCK.lock();
            try {
                if (this.allMethods == null) {
                    this.allMethods = ReflectSupport._findAllMethods(this);
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return (MethodInfo[])this.allMethods.clone();
    }

    @Override
    public ClassInfo enumClass() {
        if (this.enumClass == null) {
            this.LOCK.lock();
            try {
                if (this.enumClass == null) {
                    this.enumClass = ReflectSupport._findEnumClass(this);
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return this.enumClass;
    }

    @Override
    public RecordComponentInfo[] recordComponents() {
        if (this.recordComponents == null) {
            this.LOCK.lock();
            try {
                if (this.recordComponents == null) {
                    this.recordComponents = ReflectSupport._findRecordComponents(this);
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        return (RecordComponentInfo[])this.recordComponents.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ClassInfoImpl) {
            ClassInfoImpl o = (ClassInfoImpl)object;
            return this.rawClass == o.rawClass && this.bindings.equals(o.bindings);
        }
        return false;
    }

    private int _hashCode() {
        int result = this.rawClass.hashCode();
        result = 31 * result + this.bindings.hashCode();
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        String baseName;
        String string = baseName = this.isAnonymousClass ? this.name : this.rawClass.getSimpleName();
        if (this.bindings.isEmpty()) {
            return baseName;
        }
        StringBuilder sb = new StringBuilder(baseName);
        sb.append('<');
        TypeInfo[] typeInfos = this.bindings.typeInfos();
        for (int i = 0; i < typeInfos.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(typeInfos[i].toString());
        }
        sb.append(">");
        return sb.toString();
    }
}

