/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.ArrayTypeInfo;
import cool.scx.reflect.ArrayTypeInfoImpl;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassInfoImpl;
import cool.scx.reflect.PrimitiveTypeInfo;
import cool.scx.reflect.PrimitiveTypeInfoImpl;
import cool.scx.reflect.TypeBindingsImpl;
import cool.scx.reflect.TypeInfo;
import cool.scx.reflect.TypeResolutionContext;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class TypeFactory {
    public static final Map<Object, TypeInfo> TYPE_CACHE = new ConcurrentHashMap<Object, TypeInfo>();
    private static final Lock LOCK = new ReentrantLock();

    TypeFactory() {
    }

    public static TypeInfo typeOfAny(Type type, TypeResolutionContext context) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, ParameterizedType.class, GenericArrayType.class, TypeVariable.class, WildcardType.class}, (Type)type3, n)) {
            case 0 -> {
                Class c = (Class)type3;
                yield TypeFactory.typeOfClass(c);
            }
            case 1 -> {
                ParameterizedType p = (ParameterizedType)type3;
                yield TypeFactory.typeOfParameterizedType(p, context);
            }
            case 2 -> {
                GenericArrayType g = (GenericArrayType)type3;
                yield TypeFactory.typeOfGenericArrayType(g, context);
            }
            case 3 -> {
                TypeVariable t = (TypeVariable)type3;
                yield TypeFactory.typeOfTypeVariable(t, context);
            }
            case 4 -> {
                WildcardType w = (WildcardType)type3;
                yield TypeFactory.typeOfWildcardType(w, context);
            }
            default -> throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
        };
    }

    public static TypeInfo typeOfClass(Class<?> clazz) {
        TypeInfo result = TYPE_CACHE.get(clazz);
        if (result != null) {
            return result;
        }
        LOCK.lock();
        try {
            result = TYPE_CACHE.get(clazz);
            if (result != null) {
                TypeInfo typeInfo = result;
                return typeInfo;
            }
            result = clazz.isArray() ? new ArrayTypeInfoImpl(clazz) : (clazz.isPrimitive() ? new PrimitiveTypeInfoImpl(clazz) : new ClassInfoImpl(clazz));
            TYPE_CACHE.put(clazz, result);
            TypeInfo typeInfo = result;
            return typeInfo;
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeInfo typeOfParameterizedType(ParameterizedType parameterizedType, TypeResolutionContext context) {
        if (context.bindings() == TypeBindingsImpl.EMPTY_BINDINGS) {
            TypeInfo result = TYPE_CACHE.get(parameterizedType);
            if (result != null) {
                return result;
            }
            LOCK.lock();
            try {
                result = TYPE_CACHE.get(parameterizedType);
                if (result != null) {
                    TypeInfo typeInfo = result;
                    return typeInfo;
                }
                ClassInfoImpl classInfo = new ClassInfoImpl(parameterizedType, context);
                TypeInfo oldTypeInfo = TYPE_CACHE.get(classInfo);
                if (oldTypeInfo != null) {
                    TYPE_CACHE.put(parameterizedType, oldTypeInfo);
                    TypeInfo typeInfo = oldTypeInfo;
                    return typeInfo;
                }
                TYPE_CACHE.put(parameterizedType, classInfo);
                TYPE_CACHE.put(classInfo, classInfo);
                ClassInfoImpl classInfoImpl = classInfo;
                return classInfoImpl;
            }
            finally {
                LOCK.unlock();
            }
        }
        ClassInfoImpl classInfo = new ClassInfoImpl(parameterizedType, context);
        TypeInfo result = TYPE_CACHE.get(classInfo);
        if (result != null) {
            return result;
        }
        LOCK.lock();
        try {
            result = TYPE_CACHE.get(classInfo);
            if (result != null) {
                TypeInfo typeInfo = result;
                return typeInfo;
            }
            TYPE_CACHE.put(classInfo, classInfo);
            ClassInfoImpl classInfoImpl = classInfo;
            return classInfoImpl;
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeInfo typeOfGenericArrayType(GenericArrayType genericArrayType, TypeResolutionContext context) {
        if (context.bindings() == TypeBindingsImpl.EMPTY_BINDINGS) {
            TypeInfo result = TYPE_CACHE.get(genericArrayType);
            if (result != null) {
                return result;
            }
            LOCK.lock();
            try {
                result = TYPE_CACHE.get(genericArrayType);
                if (result != null) {
                    TypeInfo typeInfo = result;
                    return typeInfo;
                }
                ArrayTypeInfoImpl arrayTypeInfo = new ArrayTypeInfoImpl(genericArrayType, context);
                TypeInfo oldArrayTypeInfo = TYPE_CACHE.get(arrayTypeInfo);
                if (oldArrayTypeInfo != null) {
                    TYPE_CACHE.put(genericArrayType, oldArrayTypeInfo);
                    TypeInfo typeInfo = oldArrayTypeInfo;
                    return typeInfo;
                }
                boolean canOptimize2 = TypeFactory.canReuseRawClass(arrayTypeInfo);
                if (!canOptimize2) {
                    TYPE_CACHE.put(genericArrayType, arrayTypeInfo);
                    TYPE_CACHE.put(arrayTypeInfo, arrayTypeInfo);
                    ArrayTypeInfoImpl arrayTypeInfoImpl = arrayTypeInfo;
                    return arrayTypeInfoImpl;
                }
                oldArrayTypeInfo = TYPE_CACHE.get(arrayTypeInfo.rawClass());
                if (oldArrayTypeInfo != null) {
                    TYPE_CACHE.put(genericArrayType, oldArrayTypeInfo);
                    TYPE_CACHE.put(arrayTypeInfo, oldArrayTypeInfo);
                    TypeInfo typeInfo = oldArrayTypeInfo;
                    return typeInfo;
                }
                TYPE_CACHE.put(genericArrayType, arrayTypeInfo);
                TYPE_CACHE.put(arrayTypeInfo, arrayTypeInfo);
                TYPE_CACHE.put(arrayTypeInfo.rawClass(), arrayTypeInfo);
                ArrayTypeInfoImpl arrayTypeInfoImpl = arrayTypeInfo;
                return arrayTypeInfoImpl;
            }
            finally {
                LOCK.unlock();
            }
        }
        ArrayTypeInfoImpl arrayTypeInfo = new ArrayTypeInfoImpl(genericArrayType, context);
        TypeInfo result = TYPE_CACHE.get(arrayTypeInfo);
        if (result != null) {
            return result;
        }
        LOCK.lock();
        try {
            result = TYPE_CACHE.get(arrayTypeInfo);
            if (result != null) {
                TypeInfo oldArrayTypeInfo = result;
                return oldArrayTypeInfo;
            }
            boolean canOptimize = TypeFactory.canReuseRawClass(arrayTypeInfo);
            if (!canOptimize) {
                TYPE_CACHE.put(arrayTypeInfo, arrayTypeInfo);
                ArrayTypeInfoImpl canOptimize2 = arrayTypeInfo;
                return canOptimize2;
            }
            TypeInfo oldArrayTypeInfo = TYPE_CACHE.get(arrayTypeInfo.rawClass());
            if (oldArrayTypeInfo != null) {
                TYPE_CACHE.put(arrayTypeInfo, oldArrayTypeInfo);
                TypeInfo typeInfo = oldArrayTypeInfo;
                return typeInfo;
            }
            TYPE_CACHE.put(arrayTypeInfo, arrayTypeInfo);
            TYPE_CACHE.put(arrayTypeInfo.rawClass(), arrayTypeInfo);
            ArrayTypeInfoImpl arrayTypeInfoImpl = arrayTypeInfo;
            return arrayTypeInfoImpl;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static TypeInfo typeOfTypeVariable(TypeVariable<?> typeVariable, TypeResolutionContext context) {
        TypeInfo typeInfo = context.bindings().get(typeVariable);
        if (typeInfo != null) {
            return typeInfo;
        }
        Type bound = typeVariable.getBounds()[0];
        ClassInfo classInfo = context.inProgressTypes().get(bound);
        if (classInfo != null) {
            return TypeFactory.typeOfClass(classInfo.rawClass());
        }
        return TypeFactory.typeOfAny(bound, context);
    }

    public static TypeInfo typeOfWildcardType(WildcardType wildcardType, TypeResolutionContext context) {
        Type bound = wildcardType.getUpperBounds()[0];
        ClassInfo classInfo = context.inProgressTypes().get(bound);
        if (classInfo != null) {
            return TypeFactory.typeOfClass(classInfo.rawClass());
        }
        return TypeFactory.typeOfAny(bound, context);
    }

    public static boolean canReuseRawClass(ArrayTypeInfo arrayTypeInfo) {
        TypeInfo componentType;
        TypeInfo typeInfo = componentType = arrayTypeInfo.componentType();
        Objects.requireNonNull(typeInfo);
        TypeInfo typeInfo2 = typeInfo;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveTypeInfo.class, ClassInfo.class, ArrayTypeInfo.class}, (TypeInfo)typeInfo2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> {
                ClassInfo classInfo = (ClassInfo)typeInfo2;
                if (classInfo.bindings() == TypeBindingsImpl.EMPTY_BINDINGS) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                ArrayTypeInfo innerArray = (ArrayTypeInfo)typeInfo2;
                yield TypeFactory.canReuseRawClass(innerArray);
            }
        };
    }
}

