/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.ReflectSupport;
import cool.scx.reflect.TypeFactory;
import cool.scx.reflect.TypeInfo;
import cool.scx.reflect.TypeResolutionContext;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Field;
import java.util.Set;

final class FieldInfoImpl
implements FieldInfo {
    private final Field rawField;
    private final ClassInfo declaringClass;
    private final String name;
    private final AccessModifier accessModifier;
    private final boolean isFinal;
    private final boolean isStatic;
    private final TypeInfo fieldType;
    private final int hashCode;

    FieldInfoImpl(Field field, ClassInfo declaringClass) {
        this.rawField = field;
        this.declaringClass = declaringClass;
        this.name = this.rawField.getName();
        Set<AccessFlag> accessFlags = this.rawField.accessFlags();
        this.accessModifier = ReflectSupport._findAccessModifier(accessFlags);
        this.isFinal = accessFlags.contains((Object)AccessFlag.FINAL);
        this.isStatic = accessFlags.contains((Object)AccessFlag.STATIC);
        this.fieldType = TypeFactory.typeOfAny(this.rawField.getGenericType(), new TypeResolutionContext(this.declaringClass.bindings()));
        this.hashCode = this._hashCode();
    }

    @Override
    public Field rawField() {
        return this.rawField;
    }

    @Override
    public ClassInfo declaringClass() {
        return this.declaringClass;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public AccessModifier accessModifier() {
        return this.accessModifier;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public TypeInfo fieldType() {
        return this.fieldType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FieldInfoImpl) {
            FieldInfoImpl o = (FieldInfoImpl)object;
            return this.rawField.equals(o.rawField);
        }
        return false;
    }

    private int _hashCode() {
        int result = FieldInfoImpl.class.hashCode();
        result = 31 * result + this.rawField.hashCode();
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.accessModifier.name().toLowerCase());
        if (this.isStatic) {
            sb.append(" static");
        }
        if (this.isFinal) {
            sb.append(" final");
        }
        sb.append(" ");
        sb.append(this.fieldType.toString());
        sb.append(" ");
        sb.append(this.name);
        return sb.toString();
    }
}

