/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.ReflectSupport;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class MethodSignature {
    private final MethodInfo methodInfo;
    private final String name;
    private final Class<?>[] parameterTypes;
    private final int hashCode;

    public MethodSignature(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
        this.name = methodInfo.name();
        this.parameterTypes = ReflectSupport._findParameterTypes(methodInfo);
        this.hashCode = this._hashCode();
    }

    public MethodInfo methodInfo() {
        return this.methodInfo;
    }

    public String name() {
        return this.name;
    }

    public Class<?>[] parameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MethodSignature) {
            MethodSignature o = (MethodSignature)object;
            return this.name.equals(o.name) && Arrays.equals(this.parameterTypes, o.parameterTypes);
        }
        return false;
    }

    private int _hashCode() {
        int result = Objects.hashCode(this.name);
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("(");
        List<String> paramsStr = Arrays.stream(this.parameterTypes).map(Class::getSimpleName).toList();
        sb.append(String.join((CharSequence)", ", paramsStr));
        sb.append(")");
        return sb.toString();
    }
}

