/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassKind;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.ConstructorInfoImpl;
import cool.scx.reflect.ExecutableInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.FieldInfoImpl;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.MethodInfoImpl;
import cool.scx.reflect.MethodSignature;
import cool.scx.reflect.ParameterInfo;
import cool.scx.reflect.ParameterInfoImpl;
import cool.scx.reflect.RecordComponentInfo;
import cool.scx.reflect.RecordComponentInfoImpl;
import cool.scx.reflect.TypeBindings;
import cool.scx.reflect.TypeBindingsImpl;
import cool.scx.reflect.TypeFactory;
import cool.scx.reflect.TypeInfo;
import cool.scx.reflect.TypeResolutionContext;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class ReflectSupport {
    ReflectSupport() {
    }

    public static TypeBindings _findBindings(ParameterizedType type, TypeResolutionContext context) {
        TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
        Type[] actualTypeArguments = type.getActualTypeArguments();
        TypeInfo[] typeInfos = new TypeInfo[actualTypeArguments.length];
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            TypeInfo typeInfo;
            Type actualTypeArgument = actualTypeArguments[i];
            typeInfos[i] = typeInfo = TypeFactory.typeOfAny(actualTypeArgument, context);
        }
        return new TypeBindingsImpl(typeVariables, typeInfos);
    }

    public static AccessModifier _findAccessModifier(Set<AccessFlag> accessFlags) {
        if (accessFlags.contains((Object)AccessFlag.PUBLIC)) {
            return AccessModifier.PUBLIC;
        }
        if (accessFlags.contains((Object)AccessFlag.PROTECTED)) {
            return AccessModifier.PROTECTED;
        }
        if (accessFlags.contains((Object)AccessFlag.PRIVATE)) {
            return AccessModifier.PRIVATE;
        }
        return AccessModifier.PACKAGE_PRIVATE;
    }

    public static ClassKind _findClassKind(Class<?> rawClass, Set<AccessFlag> accessFlags) {
        if (accessFlags.contains((Object)AccessFlag.ANNOTATION)) {
            return ClassKind.ANNOTATION;
        }
        if (accessFlags.contains((Object)AccessFlag.INTERFACE)) {
            return ClassKind.INTERFACE;
        }
        if (accessFlags.contains((Object)AccessFlag.ENUM)) {
            return ClassKind.ENUM;
        }
        if (rawClass.isRecord()) {
            return ClassKind.RECORD;
        }
        return ClassKind.CLASS;
    }

    public static ClassInfo _findSuperClass(Class<?> rawClass, TypeBindings contextBindings) {
        Type superClass = rawClass.getGenericSuperclass();
        return superClass != null ? (ClassInfo)TypeFactory.typeOfAny(superClass, new TypeResolutionContext(contextBindings)) : null;
    }

    public static ClassInfo[] _findInterfaces(Class<?> rawClass, TypeBindings contextBindings) {
        Type[] interfaces = rawClass.getGenericInterfaces();
        ClassInfo[] result = new ClassInfo[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            result[i] = (ClassInfo)TypeFactory.typeOfAny(interfaces[i], new TypeResolutionContext(contextBindings));
        }
        return result;
    }

    public static ConstructorInfo[] _findConstructors(Class<?> rawClass, ClassInfo classInfo) {
        Constructor<?>[] constructors = rawClass.getDeclaredConstructors();
        ConstructorInfo[] result = new ConstructorInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            result[i] = new ConstructorInfoImpl(constructors[i], classInfo);
        }
        return result;
    }

    public static FieldInfo[] _findFields(Class<?> rawClass, ClassInfo classInfo) {
        Field[] fields = rawClass.getDeclaredFields();
        FieldInfo[] result = new FieldInfo[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = new FieldInfoImpl(fields[i], classInfo);
        }
        return result;
    }

    public static MethodInfo[] _findMethods(Class<?> rawClass, ClassInfo classInfo) {
        Method[] methods = rawClass.getDeclaredMethods();
        ArrayList<MethodInfoImpl> list = new ArrayList<MethodInfoImpl>();
        for (Method method : methods) {
            if (method.isBridge()) continue;
            list.add(new MethodInfoImpl(method, classInfo));
        }
        return (MethodInfo[])list.toArray(MethodInfo[]::new);
    }

    public static ClassInfo[] _findAllSuperClasses(ClassInfo classInfo) {
        ArrayList<ClassInfo> allSuperClasses = new ArrayList<ClassInfo>();
        for (ClassInfo superClass = classInfo.superClass(); superClass != null; superClass = superClass.superClass()) {
            allSuperClasses.add(superClass);
        }
        return (ClassInfo[])allSuperClasses.toArray(ClassInfo[]::new);
    }

    public static ClassInfo[] _findAllInterfaces(ClassInfo classInfo) {
        ClassInfo[] parents;
        LinkedHashSet<ClassInfo> result = new LinkedHashSet<ClassInfo>();
        ClassInfo superClass = classInfo.superClass();
        ClassInfo[] interfaces = classInfo.interfaces();
        if (superClass != null) {
            parents = new ClassInfo[interfaces.length + 1];
            parents[0] = superClass;
            System.arraycopy(interfaces, 0, parents, 1, interfaces.length);
        } else {
            parents = classInfo.interfaces();
        }
        Collections.addAll(result, interfaces);
        ClassInfo[][] temp = new ClassInfo[parents.length][];
        int maxDepth = 0;
        for (int i = 0; i < parents.length; ++i) {
            temp[i] = parents[i].allInterfaces();
            if (temp[i].length <= maxDepth) continue;
            maxDepth = temp[i].length;
        }
        for (int level = 0; level < maxDepth; ++level) {
            for (ClassInfo[] classInfos : temp) {
                if (level >= classInfos.length) continue;
                result.add(classInfos[level]);
            }
        }
        return (ClassInfo[])result.toArray(ClassInfo[]::new);
    }

    public static ParameterInfo[] _findParameters(Executable rawExecutable, ExecutableInfo executableInfo) {
        Parameter[] parameters = rawExecutable.getParameters();
        ParameterInfo[] result = new ParameterInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            result[i] = new ParameterInfoImpl(parameters[i], executableInfo);
        }
        return result;
    }

    public static ConstructorInfo _findDefaultConstructor(ClassInfo classInfo) {
        for (ConstructorInfo constructor : classInfo.constructors()) {
            if (constructor.parameters().length != 0) continue;
            return constructor;
        }
        return null;
    }

    public static ConstructorInfo _findRecordConstructor(ClassInfo classInfo) {
        if (classInfo.classKind() != ClassKind.RECORD) {
            return null;
        }
        TypeInfo[] recordComponentTypes = ReflectSupport._getRecordComponentsTypes(classInfo);
        for (ConstructorInfo constructor : classInfo.constructors()) {
            boolean matched = ReflectSupport._hasSameParameterTypes(constructor, recordComponentTypes);
            if (!matched) continue;
            return constructor;
        }
        return null;
    }

    private static TypeInfo[] _getRecordComponentsTypes(ClassInfo classInfo) {
        RecordComponentInfo[] recordComponents = classInfo.recordComponents();
        TypeInfo[] result = new TypeInfo[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            result[i] = recordComponents[i].recordComponentType();
        }
        return result;
    }

    private static boolean _hasSameParameterTypes(ExecutableInfo constructorInfo, TypeInfo[] types) {
        if (constructorInfo.parameters().length != types.length) {
            return false;
        }
        ParameterInfo[] p1 = constructorInfo.parameters();
        for (int i = 0; i < p1.length; ++i) {
            TypeInfo p2Type;
            TypeInfo p1Type = p1[i].parameterType();
            if (p1Type == (p2Type = types[i])) continue;
            return false;
        }
        return true;
    }

    public static FieldInfo[] _findAllFields(ClassInfo classInfo) {
        ArrayList allFieldInfos = new ArrayList();
        Collections.addAll(allFieldInfos, classInfo.fields());
        ClassInfo superClass = classInfo.superClass();
        if (superClass != null) {
            Collections.addAll(allFieldInfos, superClass.allFields());
        }
        return (FieldInfo[])allFieldInfos.toArray(FieldInfo[]::new);
    }

    public static MethodInfo[] _findSuperMethods(MethodInfo methodInfo) {
        if (methodInfo.isStatic()) {
            return new MethodInfo[0];
        }
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        block0: for (ClassInfo i : methodInfo.declaringClass().allSuperClasses()) {
            for (MethodInfo superMethod : i.methods()) {
                if (superMethod.isStatic() || superMethod.isFinal() || !ReflectSupport.isOverride(methodInfo, superMethod)) continue;
                result.add(superMethod);
                break block0;
            }
        }
        HashSet needSkip = new HashSet();
        block2: for (ClassInfo i : methodInfo.declaringClass().allInterfaces()) {
            if (needSkip.contains(i)) continue;
            for (MethodInfo superMethod : i.methods()) {
                if (superMethod.isStatic() || superMethod.isFinal() || !ReflectSupport.isOverride(methodInfo, superMethod)) continue;
                result.add(superMethod);
                Collections.addAll(needSkip, i.allInterfaces());
                continue block2;
            }
        }
        return (MethodInfo[])result.toArray(MethodInfo[]::new);
    }

    public static MethodInfo[] _findAllSuperMethods(MethodInfo methodInfo) {
        LinkedHashSet<MethodInfo> result = new LinkedHashSet<MethodInfo>();
        MethodInfo[] superMethods = methodInfo.superMethods();
        Collections.addAll(result, superMethods);
        MethodInfo[][] temp = new MethodInfo[superMethods.length][];
        int maxDepth = 0;
        for (int i = 0; i < superMethods.length; ++i) {
            temp[i] = superMethods[i].allSuperMethods();
            if (temp[i].length <= maxDepth) continue;
            maxDepth = temp[i].length;
        }
        for (int level = 0; level < maxDepth; ++level) {
            for (MethodInfo[] methodInfos : temp) {
                if (level >= methodInfos.length) continue;
                result.add(methodInfos[level]);
            }
        }
        return (MethodInfo[])result.toArray(MethodInfo[]::new);
    }

    public static MethodInfo[] _findAllMethods(ClassInfo classInfo) {
        ClassInfo[] interfaces;
        LinkedHashSet<MethodInfo> staticMethods = new LinkedHashSet<MethodInfo>();
        LinkedHashSet<MethodInfo> instanceMethods = new LinkedHashSet<MethodInfo>();
        for (MethodInfo method : classInfo.methods()) {
            if (method.isStatic()) {
                staticMethods.add(method);
                continue;
            }
            instanceMethods.add(method);
        }
        ClassInfo superClass = classInfo.superClass();
        if (superClass != null) {
            for (MethodInfo method : superClass.allMethods()) {
                if (method.isStatic()) {
                    staticMethods.add(method);
                    continue;
                }
                instanceMethods.add(method);
            }
        }
        for (ClassInfo i : interfaces = classInfo.interfaces()) {
            for (MethodInfo method : i.allMethods()) {
                if (method.isStatic()) {
                    staticMethods.add(method);
                    continue;
                }
                instanceMethods.add(method);
            }
        }
        ArrayList<MethodInfo> finalInstanceMethods = new ArrayList<MethodInfo>();
        Map<MethodSignature, List<MethodInfo>> map = instanceMethods.stream().collect(Collectors.groupingBy(MethodInfo::signature));
        for (Map.Entry<MethodSignature, List<MethodInfo>> e : map.entrySet()) {
            List<MethodInfo> value = e.getValue();
            if (value.size() == 1) {
                finalInstanceMethods.addAll(value);
                continue;
            }
            List<MethodInfo> methodInfos = ReflectSupport._selectMethods(value);
            finalInstanceMethods.addAll(methodInfos);
        }
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        result.addAll(staticMethods);
        result.addAll(finalInstanceMethods);
        return (MethodInfo[])result.toArray(MethodInfo[]::new);
    }

    public static List<MethodInfo> _selectMethods(List<MethodInfo> methodInfos) {
        ArrayList override = new ArrayList();
        for (MethodInfo methodInfo : methodInfos) {
            Collections.addAll(override, methodInfo.allSuperMethods());
        }
        methodInfos.removeAll(override);
        List<MethodInfo> concreteMethods = methodInfos.stream().filter(m -> !m.isAbstract()).toList();
        if (concreteMethods.size() == 1) {
            return concreteMethods;
        }
        if (concreteMethods.size() > 1) {
            for (MethodInfo concreteMethod : concreteMethods) {
                if (concreteMethod.isDefault()) continue;
                return List.of(concreteMethod);
            }
            throw new IllegalStateException("\u5b58\u5728\u591a\u4e2a default \u65b9\u6cd5, \u4f46\u672a\u627e\u5230\u4efb\u4f55\u5b9e\u4f8b\u65b9\u6cd5.");
        }
        return methodInfos;
    }

    public static ClassInfo _findEnumClass(ClassInfo classInfo) {
        if (classInfo.classKind() == ClassKind.ENUM) {
            return classInfo.isAnonymousClass() ? classInfo.superClass() : classInfo;
        }
        return null;
    }

    public static RecordComponentInfo[] _findRecordComponents(ClassInfo classInfo) {
        if (classInfo.classKind() == ClassKind.RECORD) {
            RecordComponent[] recordComponents = classInfo.rawClass().getRecordComponents();
            RecordComponentInfo[] result = new RecordComponentInfo[recordComponents.length];
            for (int i = 0; i < recordComponents.length; ++i) {
                result[i] = new RecordComponentInfoImpl(recordComponents[i], classInfo);
            }
            return result;
        }
        return new RecordComponentInfo[0];
    }

    private static boolean isOverride(MethodInfo methodInfo, MethodInfo superMethod) {
        String p2;
        String p1;
        if (superMethod.accessModifier() == AccessModifier.PRIVATE) {
            return false;
        }
        if (superMethod.accessModifier() == AccessModifier.PACKAGE_PRIVATE && !(p1 = superMethod.declaringClass().rawClass().getPackageName()).equals(p2 = methodInfo.declaringClass().rawClass().getPackageName())) {
            return false;
        }
        return methodInfo.signature().equals(superMethod.signature());
    }

    public static Class<?>[] _findParameterTypes(MethodInfo methodInfo) {
        ParameterInfo[] parameterInfos = methodInfo.parameters();
        Class[] parameterTypes = new Class[parameterInfos.length];
        for (int i = 0; i < parameterInfos.length; ++i) {
            parameterTypes[i] = parameterInfos[i].parameterType().rawClass();
        }
        return parameterTypes;
    }
}

