/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduling;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

final class ScxThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private final AtomicLong threadNumber = new AtomicLong(0L);
    private final String namePrefix = "scx-" + POOL_NUMBER.getAndIncrement() + "-virtual-thread-";
    private Function<Runnable, Thread> newThread = r -> {
        this.newThread = c -> Thread.ofVirtual().name(this.namePrefix, this.threadNumber.getAndIncrement()).unstarted((Runnable)c);
        return Thread.ofPlatform().name(this.namePrefix, this.threadNumber.getAndIncrement()).unstarted((Runnable)r);
    };

    @Override
    public Thread newThread(Runnable r) {
        return this.newThread.apply(r);
    }
}

