/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduling;

import cool.scx.scheduling.ExpirationPolicy;
import cool.scx.scheduling.ScheduleStatus;
import cool.scx.scheduling.ScheduleTask;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class MultipleTimeTask
implements ScheduleTask {
    private static final System.Logger logger = System.getLogger(MultipleTimeTask.class.getName());
    private final AtomicLong runCount = new AtomicLong(0L);
    private Supplier<Instant> startTimeSupplier = null;
    private Duration delay = null;
    private Type type = Type.FIXED_RATE;
    private boolean concurrent = false;
    private long maxRunCount = -1L;
    private ExpirationPolicy expirationPolicy = ExpirationPolicy.IMMEDIATE_COMPENSATION;
    private ScheduledExecutorService executor = null;
    private Consumer<ScheduleStatus> task = null;
    private ScheduledFuture<?> scheduledFuture = null;

    public MultipleTimeTask startTime(Supplier<Instant> startTime) {
        this.startTimeSupplier = startTime;
        return this;
    }

    public MultipleTimeTask startTime(Instant startTime) {
        this.startTimeSupplier = () -> startTime;
        return this;
    }

    public MultipleTimeTask delay(Duration delay) {
        this.delay = delay;
        return this;
    }

    public MultipleTimeTask type(Type type) {
        this.type = type;
        return this;
    }

    @Override
    public MultipleTimeTask concurrent(boolean concurrentExecution) {
        this.concurrent = concurrentExecution;
        return this;
    }

    @Override
    public MultipleTimeTask maxRunCount(long maxRunCount) {
        this.maxRunCount = maxRunCount;
        return this;
    }

    @Override
    public MultipleTimeTask expirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
        return this;
    }

    @Override
    public MultipleTimeTask executor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public MultipleTimeTask task(Consumer<ScheduleStatus> task) {
        this.task = task;
        return this;
    }

    @Override
    public ScheduleStatus start() {
        Instant startTime;
        if (this.delay == null) {
            throw new IllegalArgumentException("Delay must be non-null");
        }
        Instant now = Instant.now();
        Instant instant = startTime = this.startTimeSupplier != null ? this.startTimeSupplier.get() : null;
        if (startTime == null) {
            return this.doStart(0L);
        }
        Duration between = Duration.between(now, startTime);
        if (!between.isNegative()) {
            return this.doStart(between.toNanos());
        }
        if (this.expirationPolicy == ExpirationPolicy.IMMEDIATE_IGNORE || this.expirationPolicy == ExpirationPolicy.BACKTRACKING_IGNORE) {
            long delayCount = between.dividedBy(this.delay) * -1L;
            Instant nearestTime = startTime.plus(this.delay.multipliedBy(delayCount + 1L));
            if (this.expirationPolicy == ExpirationPolicy.BACKTRACKING_IGNORE) {
                this.runCount.addAndGet(delayCount);
            }
            return this.doStart(Duration.between(now, nearestTime).toNanos());
        }
        if (this.expirationPolicy == ExpirationPolicy.IMMEDIATE_COMPENSATION || this.expirationPolicy == ExpirationPolicy.BACKTRACKING_COMPENSATION) {
            if (this.expirationPolicy == ExpirationPolicy.BACKTRACKING_COMPENSATION) {
                long delayCount = between.dividedBy(this.delay) * -1L;
                int i = 0;
                while ((long)i < delayCount) {
                    this.run();
                    ++i;
                }
            }
            return this.doStart(0L);
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.expirationPolicy));
    }

    private void run() {
        if (this.concurrent) {
            Thread.ofVirtual().start(this::run0);
        } else {
            this.run0();
        }
    }

    private void run0() {
        final long l = this.runCount.incrementAndGet();
        if (this.maxRunCount != -1L && l > this.maxRunCount) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            return;
        }
        try {
            this.task.accept(new ScheduleStatus(){
                final /* synthetic */ MultipleTimeTask this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public long runCount() {
                    return l;
                }

                @Override
                public void cancel() {
                    this.this$0.scheduledFuture.cancel(false);
                }
            });
        }
        catch (Throwable e) {
            logger.log(System.Logger.Level.ERROR, "\u8c03\u5ea6\u4efb\u52a1\u65f6\u53d1\u751f\u9519\u8bef !!!", e);
        }
    }

    private ScheduleStatus doStart(long startDelay) {
        this.scheduledFuture = switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.executor.scheduleAtFixedRate(this::run, startDelay, this.delay.toNanos(), TimeUnit.NANOSECONDS);
            case 1 -> this.executor.scheduleWithFixedDelay(this::run, startDelay, this.delay.toNanos(), TimeUnit.NANOSECONDS);
        };
        return new ScheduleStatus(){

            @Override
            public long runCount() {
                return MultipleTimeTask.this.runCount.get();
            }

            @Override
            public void cancel() {
                MultipleTimeTask.this.scheduledFuture.cancel(false);
            }
        };
    }

    public static enum Type {
        FIXED_RATE,
        FIXED_DELAY;

    }
}

