/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduling;

import cool.scx.scheduling.CronTask;
import cool.scx.scheduling.MultipleTimeTask;
import cool.scx.scheduling.ScheduleStatus;
import cool.scx.scheduling.ScxScheduler;
import cool.scx.scheduling.SingleTimeTask;
import java.time.Duration;

public interface ScxScheduling {
    public static MultipleTimeTask fixedRate() {
        return new MultipleTimeTask().executor(ScxScheduler.getInstance()).type(MultipleTimeTask.Type.FIXED_RATE);
    }

    public static MultipleTimeTask fixedDelay() {
        return new MultipleTimeTask().executor(ScxScheduler.getInstance()).type(MultipleTimeTask.Type.FIXED_DELAY);
    }

    public static CronTask cron() {
        return new CronTask().executor(ScxScheduler.getInstance());
    }

    public static SingleTimeTask once() {
        return new SingleTimeTask().executor(ScxScheduler.getInstance());
    }

    public static ScheduleStatus setTimeout(Runnable task, long delay) {
        return ScxScheduling.once().startDelay(Duration.ofMillis(delay)).start(c -> task.run());
    }

    public static ScheduleStatus setInterval(Runnable task, long delay) {
        return ScxScheduling.fixedRate().delay(Duration.ofMillis(delay)).start(c -> task.run());
    }
}

