/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduling;

import cool.scx.scheduling.ExpirationPolicy;
import cool.scx.scheduling.ScheduleStatus;
import cool.scx.scheduling.SingleTimeTask;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class SingleTimeTaskImpl
implements SingleTimeTask {
    private static final System.Logger logger = System.getLogger(SingleTimeTaskImpl.class.getName());
    private final AtomicLong runCount = new AtomicLong(0L);
    private Supplier<Long> startDelaySupplier = null;
    private ExpirationPolicy expirationPolicy = ExpirationPolicy.IMMEDIATE_COMPENSATION;
    private ScheduledExecutorService executor = null;
    private Consumer<ScheduleStatus> task = null;

    @Override
    public SingleTimeTask startTime(Supplier<Instant> startTime) {
        this.startDelaySupplier = () -> Duration.between(Instant.now(), (Temporal)startTime.get()).toNanos();
        return this;
    }

    @Override
    public SingleTimeTask startTime(Instant startTime) {
        this.startDelaySupplier = () -> Duration.between(Instant.now(), startTime).toNanos();
        return this;
    }

    @Override
    public SingleTimeTask startDelay(Duration delay) {
        this.startDelaySupplier = delay::toNanos;
        return this;
    }

    @Override
    public SingleTimeTask expirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
        return this;
    }

    @Override
    public SingleTimeTask executor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public SingleTimeTask task(Consumer<ScheduleStatus> task) {
        this.task = task;
        return this;
    }

    @Override
    public ScheduleStatus start() {
        long startDelay;
        long l = startDelay = this.startDelaySupplier != null ? this.startDelaySupplier.get() : 0L;
        if (startDelay >= 0L) {
            return this.doStart(startDelay);
        }
        if (this.expirationPolicy == ExpirationPolicy.IMMEDIATE_IGNORE || this.expirationPolicy == ExpirationPolicy.BACKTRACKING_IGNORE) {
            if (this.expirationPolicy == ExpirationPolicy.BACKTRACKING_IGNORE) {
                this.runCount.incrementAndGet();
            }
            return new ScheduleStatus(){

                @Override
                public long runCount() {
                    return SingleTimeTaskImpl.this.runCount.get();
                }

                @Override
                public void cancel() {
                }
            };
        }
        if (this.expirationPolicy == ExpirationPolicy.IMMEDIATE_COMPENSATION || this.expirationPolicy == ExpirationPolicy.BACKTRACKING_COMPENSATION) {
            return this.doStart(0L);
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.expirationPolicy));
    }

    public ScheduleStatus doStart(long startDelay) {
        final ScheduledFuture<?> scheduledFuture = this.executor.schedule(this::run, startDelay, TimeUnit.NANOSECONDS);
        return new ScheduleStatus(){
            final /* synthetic */ SingleTimeTaskImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public long runCount() {
                return this.this$0.runCount.get();
            }

            @Override
            public void cancel() {
                scheduledFuture.cancel(false);
            }
        };
    }

    private void run() {
        final long l = this.runCount.incrementAndGet();
        try {
            this.task.accept(new ScheduleStatus(){

                @Override
                public long runCount() {
                    return l;
                }

                @Override
                public void cancel() {
                }
            });
        }
        catch (Throwable e) {
            logger.log(System.Logger.Level.ERROR, "\u8c03\u5ea6\u4efb\u52a1\u65f6\u53d1\u751f\u9519\u8bef !!!", e);
        }
    }
}

