/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduling;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import cool.scx.scheduling.CronTask;
import cool.scx.scheduling.ScheduleStatus;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class CronTaskImpl
implements CronTask {
    private static final System.Logger logger = System.getLogger(CronTaskImpl.class.getName());
    private static final CronParser CRON_PARSER = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private final AtomicLong runCount = new AtomicLong(0L);
    private final AtomicBoolean cancel = new AtomicBoolean(false);
    private ExecutionTime executionTime = null;
    private boolean concurrent = false;
    private long maxRunCount = -1L;
    private ScheduledExecutorService executor = null;
    private Consumer<ScheduleStatus> task = null;
    private ZonedDateTime lastNext = null;

    @Override
    public CronTask expression(String expression) {
        Cron cron = CRON_PARSER.parse(expression);
        this.executionTime = ExecutionTime.forCron((Cron)cron);
        return this;
    }

    @Override
    public CronTask concurrent(boolean concurrent) {
        this.concurrent = concurrent;
        return this;
    }

    @Override
    public CronTask maxRunCount(long maxRunCount) {
        this.maxRunCount = maxRunCount;
        return this;
    }

    @Override
    public CronTask executor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public CronTask task(Consumer<ScheduleStatus> task) {
        this.task = task;
        return this;
    }

    @Override
    public ScheduleStatus start() {
        this.scheduleNext();
        return new ScheduleStatus(){

            @Override
            public long runCount() {
                return CronTaskImpl.this.runCount.get();
            }

            @Override
            public void cancel() {
                CronTaskImpl.this.cancel.set(true);
            }
        };
    }

    public void run() {
        final long l = this.runCount.incrementAndGet();
        if (this.cancel.get() || this.maxRunCount != -1L && l > this.maxRunCount) {
            return;
        }
        if (this.concurrent) {
            this.scheduleNext();
        }
        try {
            this.task.accept(new ScheduleStatus(){
                final /* synthetic */ CronTaskImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public long runCount() {
                    return l;
                }

                @Override
                public void cancel() {
                    this.this$0.cancel.set(true);
                }
            });
        }
        catch (Throwable e) {
            logger.log(System.Logger.Level.ERROR, "\u8c03\u5ea6\u4efb\u52a1\u65f6\u53d1\u751f\u9519\u8bef !!!", e);
        }
        if (!this.concurrent) {
            this.scheduleNext();
        }
    }

    private void scheduleNext() {
        ZonedDateTime now = ZonedDateTime.now();
        if (this.lastNext == null) {
            this.lastNext = now;
        }
        this.lastNext = this.executionTime.nextExecution(this.lastNext).orElse(null);
        long delay = Duration.between(now, this.lastNext).toMillis();
        this.executor.schedule(this::run, delay, TimeUnit.MILLISECONDS);
    }
}

