/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduling;

import cool.scx.scheduling.CronTask;
import cool.scx.scheduling.CronTaskImpl;
import cool.scx.scheduling.MultipleTimeTask;
import cool.scx.scheduling.MultipleTimeTaskImpl;
import cool.scx.scheduling.ScheduleStatus;
import cool.scx.scheduling.SingleTimeTask;
import cool.scx.scheduling.SingleTimeTaskImpl;
import java.time.Duration;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public final class ScxScheduling {
    private static ScheduledThreadPoolExecutor defaultScheduler;

    public static ScheduledThreadPoolExecutor defaultScheduler() {
        if (defaultScheduler == null) {
            defaultScheduler = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2);
        }
        return defaultScheduler;
    }

    public static MultipleTimeTask fixedRate() {
        return new MultipleTimeTaskImpl().executor(ScxScheduling.defaultScheduler()).type(MultipleTimeTask.Type.FIXED_RATE);
    }

    public static MultipleTimeTask fixedDelay() {
        return new MultipleTimeTaskImpl().executor(ScxScheduling.defaultScheduler()).type(MultipleTimeTask.Type.FIXED_DELAY);
    }

    public static CronTask cron() {
        return new CronTaskImpl().executor(ScxScheduling.defaultScheduler());
    }

    public static SingleTimeTask once() {
        return new SingleTimeTaskImpl().executor(ScxScheduling.defaultScheduler());
    }

    public static ScheduleStatus setTimeout(Runnable task, long delay) {
        return ScxScheduling.once().startDelay(Duration.ofMillis(delay)).start(c -> task.run());
    }

    public static ScheduleStatus setInterval(Runnable task, long delay) {
        return ScxScheduling.fixedRate().delay(Duration.ofMillis(delay)).start(c -> task.run());
    }
}

