/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduling;

import cool.scx.scheduling.ScheduleContext;
import cool.scx.scheduling.cron.CronTask;
import cool.scx.scheduling.cron.CronTaskImpl;
import cool.scx.scheduling.multi_time.ExecutionPolicy;
import cool.scx.scheduling.multi_time.MultiTimeTask;
import cool.scx.scheduling.multi_time.MultiTimeTaskImpl;
import cool.scx.scheduling.single_time.SingleTimeTask;
import cool.scx.scheduling.single_time.SingleTimeTaskImpl;
import java.time.Duration;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public final class ScxScheduling {
    private static ScheduledThreadPoolExecutor defaultScheduler;

    public static ScheduledThreadPoolExecutor defaultScheduler() {
        if (defaultScheduler == null) {
            defaultScheduler = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2);
        }
        return defaultScheduler;
    }

    public static MultiTimeTask fixedRate() {
        return new MultiTimeTaskImpl().executor(ScxScheduling.defaultScheduler()).executionPolicy(ExecutionPolicy.FIXED_RATE);
    }

    public static MultiTimeTask fixedDelay() {
        return new MultiTimeTaskImpl().executor(ScxScheduling.defaultScheduler()).executionPolicy(ExecutionPolicy.FIXED_DELAY);
    }

    public static CronTask cron() {
        return new CronTaskImpl().executor(ScxScheduling.defaultScheduler());
    }

    public static SingleTimeTask once() {
        return new SingleTimeTaskImpl().executor(ScxScheduling.defaultScheduler());
    }

    public static ScheduleContext setTimeout(Runnable task, long delay) {
        return ScxScheduling.once().startDelay(Duration.ofMillis(delay)).start(c -> task.run());
    }

    public static ScheduleContext setInterval(Runnable task, long delay) {
        return ScxScheduling.fixedRate().delay(Duration.ofMillis(delay)).start(c -> task.run());
    }
}

