/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduling.multi_time;

import cool.scx.scheduling.ConcurrencyPolicy;
import cool.scx.scheduling.ExpirationPolicy;
import cool.scx.scheduling.ScheduleContext;
import cool.scx.scheduling.Task;
import cool.scx.scheduling.TaskStatus;
import cool.scx.scheduling.multi_time.ExecutionPolicy;
import cool.scx.scheduling.multi_time.MultiTimeTask;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class MultiTimeTaskImpl
implements MultiTimeTask {
    private static final System.Logger logger = System.getLogger(MultiTimeTaskImpl.class.getName());
    private final AtomicLong runCount = new AtomicLong(0L);
    private Supplier<Instant> startTimeSupplier = null;
    private Duration delay = null;
    private ExecutionPolicy executionPolicy = ExecutionPolicy.FIXED_RATE;
    private ConcurrencyPolicy concurrencyPolicy = ConcurrencyPolicy.NO_CONCURRENCY;
    private long maxRunCount = -1L;
    private ExpirationPolicy expirationPolicy = ExpirationPolicy.IMMEDIATE_COMPENSATION;
    private ScheduledExecutorService executor = null;
    private Task task = null;
    private ScheduledFuture<?> scheduledFuture = null;
    private Consumer<Throwable> errorHandler = null;
    private ScheduleContext context;
    private volatile Instant initialScheduledTime;
    private volatile Instant lastExecutionEndTime;

    @Override
    public MultiTimeTask startTime(Supplier<Instant> startTime) {
        this.startTimeSupplier = startTime;
        return this;
    }

    @Override
    public MultiTimeTask delay(Duration delay) {
        this.delay = delay;
        return this;
    }

    @Override
    public MultiTimeTask executionPolicy(ExecutionPolicy executionPolicy) {
        this.executionPolicy = executionPolicy;
        return this;
    }

    @Override
    public MultiTimeTask concurrencyPolicy(ConcurrencyPolicy concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
        return this;
    }

    @Override
    public MultiTimeTask maxRunCount(long maxRunCount) {
        this.maxRunCount = maxRunCount;
        return this;
    }

    @Override
    public MultiTimeTask expirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
        return this;
    }

    @Override
    public MultiTimeTask executor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public MultiTimeTask task(Task task) {
        this.task = task;
        return this;
    }

    @Override
    public MultiTimeTask onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    public ScheduleContext start() {
        Duration between;
        Instant startTime;
        if (this.executor == null) {
            throw new IllegalStateException("Executor \u672a\u8bbe\u7f6e !!!");
        }
        if (this.delay == null) {
            throw new IllegalStateException("Delay \u672a\u8bbe\u7f6e");
        }
        Instant now = Instant.now();
        Instant instant = startTime = this.startTimeSupplier != null ? this.startTimeSupplier.get() : null;
        if (startTime == null) {
            startTime = now;
        }
        if (!(between = Duration.between(now, startTime)).isNegative()) {
            return this.doStart(between.toNanos());
        }
        if (this.expirationPolicy == ExpirationPolicy.IMMEDIATE_IGNORE || this.expirationPolicy == ExpirationPolicy.BACKTRACKING_IGNORE) {
            long delayCount = between.dividedBy(this.delay) * -1L;
            Instant nearestTime = startTime.plus(this.delay.multipliedBy(delayCount + 1L));
            if (this.expirationPolicy == ExpirationPolicy.BACKTRACKING_IGNORE) {
                this.runCount.addAndGet(delayCount);
            }
            return this.doStart(Duration.between(now, nearestTime).toNanos());
        }
        if (this.expirationPolicy == ExpirationPolicy.IMMEDIATE_COMPENSATION || this.expirationPolicy == ExpirationPolicy.BACKTRACKING_COMPENSATION) {
            if (this.expirationPolicy == ExpirationPolicy.BACKTRACKING_COMPENSATION) {
                long delayCount = between.dividedBy(this.delay) * -1L;
                int i = 0;
                while ((long)i < delayCount) {
                    this.run();
                    ++i;
                }
            }
            return this.doStart(0L);
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.expirationPolicy));
    }

    private ScheduleContext doStart(long startDelay) {
        this.initialScheduledTime = Instant.now().plusNanos(startDelay);
        this.scheduledFuture = switch (this.executionPolicy) {
            default -> throw new MatchException(null, null);
            case ExecutionPolicy.FIXED_RATE -> this.executor.scheduleAtFixedRate(this::run, startDelay, this.delay.toNanos(), TimeUnit.NANOSECONDS);
            case ExecutionPolicy.FIXED_DELAY -> this.executor.scheduleWithFixedDelay(this::run, startDelay, this.delay.toNanos(), TimeUnit.NANOSECONDS);
        };
        this.context = new ScheduleContext(){

            @Override
            public long runCount() {
                return MultiTimeTaskImpl.this.runCount.get();
            }

            @Override
            public Instant nextRunTime() {
                if (MultiTimeTaskImpl.this.scheduledFuture.isCancelled() || MultiTimeTaskImpl.this.scheduledFuture.isDone()) {
                    return null;
                }
                return switch (MultiTimeTaskImpl.this.executionPolicy) {
                    default -> throw new MatchException(null, null);
                    case ExecutionPolicy.FIXED_RATE -> MultiTimeTaskImpl.this.initialScheduledTime.plus(MultiTimeTaskImpl.this.delay.multipliedBy(MultiTimeTaskImpl.this.runCount.get()));
                    case ExecutionPolicy.FIXED_DELAY -> {
                        Instant lastEnd = MultiTimeTaskImpl.this.lastExecutionEndTime;
                        if (lastEnd != null) {
                            yield lastEnd.plus(MultiTimeTaskImpl.this.delay);
                        }
                        yield MultiTimeTaskImpl.this.initialScheduledTime;
                    }
                };
            }

            @Override
            public Instant nextRunTime(int count) {
                if (count <= 0) {
                    throw new IllegalArgumentException("count must be positive");
                }
                if (MultiTimeTaskImpl.this.scheduledFuture.isCancelled() || MultiTimeTaskImpl.this.scheduledFuture.isDone()) {
                    return null;
                }
                return switch (MultiTimeTaskImpl.this.executionPolicy) {
                    default -> throw new MatchException(null, null);
                    case ExecutionPolicy.FIXED_RATE -> MultiTimeTaskImpl.this.initialScheduledTime.plus(MultiTimeTaskImpl.this.delay.multipliedBy(MultiTimeTaskImpl.this.runCount.get() + (long)count));
                    case ExecutionPolicy.FIXED_DELAY -> {
                        Instant next = this.nextRunTime();
                        if (next != null) {
                            yield next.plus(MultiTimeTaskImpl.this.delay.multipliedBy(count - 1));
                        }
                        yield null;
                    }
                };
            }

            @Override
            public void cancel() {
                MultiTimeTaskImpl.this.scheduledFuture.cancel(false);
            }

            @Override
            public ScheduleContext.Status status() {
                Future.State s = MultiTimeTaskImpl.this.scheduledFuture.state();
                return switch (s) {
                    default -> throw new MatchException(null, null);
                    case Future.State.RUNNING -> ScheduleContext.Status.RUNNING;
                    case Future.State.SUCCESS, Future.State.FAILED -> ScheduleContext.Status.DONE;
                    case Future.State.CANCELLED -> ScheduleContext.Status.CANCELED;
                };
            }
        };
        return this.context;
    }

    private void run() {
        switch (this.concurrencyPolicy) {
            case CONCURRENCY: {
                this.executor.execute(this::run0);
                break;
            }
            case NO_CONCURRENCY: {
                this.run0();
                break;
            }
        }
    }

    private void run0() {
        final long l = this.runCount.incrementAndGet();
        if (this.maxRunCount != -1L && l > this.maxRunCount) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            return;
        }
        try {
            this.task.run(new TaskStatus(){
                final /* synthetic */ MultiTimeTaskImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public long currentRunCount() {
                    return l;
                }

                @Override
                public ScheduleContext context() {
                    return this.this$0.context;
                }
            });
        }
        catch (Throwable e) {
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.accept(e);
                }
                catch (Throwable ex) {
                    e.addSuppressed(ex);
                    logger.log(System.Logger.Level.ERROR, "errorHandler \u53d1\u751f\u9519\u8bef !!!", e);
                }
            }
            logger.log(System.Logger.Level.ERROR, "\u8c03\u5ea6\u4efb\u52a1\u65f6\u53d1\u751f\u9519\u8bef !!!", e);
        }
        this.lastExecutionEndTime = Instant.now();
    }
}

