/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduling.multi_time;

import cool.scx.function.Function1Void;
import cool.scx.scheduling.ExpirationPolicy;
import cool.scx.scheduling.ScheduleContext;
import cool.scx.scheduling.ScheduleStatus;
import cool.scx.scheduling.TaskContext;
import cool.scx.scheduling.multi_time.ExecutionPolicy;
import cool.scx.scheduling.multi_time.MultiTimeTask;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class MultiTimeTaskImpl
implements MultiTimeTask {
    private static final System.Logger logger = System.getLogger(MultiTimeTaskImpl.class.getName());
    private final AtomicLong runCount = new AtomicLong(0L);
    private Supplier<Instant> startTimeSupplier = null;
    private Duration delay = null;
    private ExecutionPolicy executionPolicy = ExecutionPolicy.FIXED_RATE;
    private long maxRunCount = -1L;
    private ExpirationPolicy expirationPolicy = ExpirationPolicy.IMMEDIATE_COMPENSATION;
    private ScheduledExecutorService executor = null;
    private Function1Void<TaskContext, ?> task = null;
    private ScheduledFuture<?> scheduledFuture = null;
    private Consumer<Throwable> errorHandler = null;
    private ScheduleContext context;
    private volatile Instant initialScheduledTime;
    private volatile Instant lastExecutionEndTime;

    @Override
    public MultiTimeTask startTime(Supplier<Instant> startTime) {
        this.startTimeSupplier = startTime;
        return this;
    }

    @Override
    public MultiTimeTask delay(Duration delay) {
        this.delay = delay;
        return this;
    }

    @Override
    public MultiTimeTask executionPolicy(ExecutionPolicy executionPolicy) {
        this.executionPolicy = executionPolicy;
        return this;
    }

    @Override
    public MultiTimeTask maxRunCount(long maxRunCount) {
        this.maxRunCount = maxRunCount;
        return this;
    }

    @Override
    public MultiTimeTask expirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
        return this;
    }

    @Override
    public MultiTimeTask executor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public MultiTimeTask task(Function1Void<TaskContext, ?> task) {
        this.task = task;
        return this;
    }

    @Override
    public MultiTimeTask onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    public ScheduleContext start() {
        Duration between;
        Instant startTime;
        if (this.executor == null) {
            throw new IllegalStateException("Executor \u672a\u8bbe\u7f6e !!!");
        }
        if (this.delay == null) {
            throw new IllegalStateException("Delay \u672a\u8bbe\u7f6e");
        }
        Instant now = Instant.now();
        Instant instant = startTime = this.startTimeSupplier != null ? this.startTimeSupplier.get() : null;
        if (startTime == null) {
            startTime = now;
        }
        if (!(between = Duration.between(now, startTime)).isNegative()) {
            return this.doStart(between.toNanos());
        }
        if (this.expirationPolicy == ExpirationPolicy.IMMEDIATE_IGNORE || this.expirationPolicy == ExpirationPolicy.BACKTRACKING_IGNORE) {
            long delayCount = between.dividedBy(this.delay) * -1L;
            Instant nearestTime = startTime.plus(this.delay.multipliedBy(delayCount + 1L));
            if (this.expirationPolicy == ExpirationPolicy.BACKTRACKING_IGNORE) {
                this.runCount.addAndGet(delayCount);
            }
            return this.doStart(Duration.between(now, nearestTime).toNanos());
        }
        if (this.expirationPolicy == ExpirationPolicy.IMMEDIATE_COMPENSATION || this.expirationPolicy == ExpirationPolicy.BACKTRACKING_COMPENSATION) {
            if (this.expirationPolicy == ExpirationPolicy.BACKTRACKING_COMPENSATION) {
                long delayCount = between.dividedBy(this.delay) * -1L;
                int i = 0;
                while ((long)i < delayCount) {
                    this.run();
                    ++i;
                }
            }
            return this.doStart(0L);
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.expirationPolicy));
    }

    private ScheduleContext doStart(long startDelay) {
        this.initialScheduledTime = Instant.now().plusNanos(startDelay);
        this.scheduledFuture = switch (this.executionPolicy) {
            default -> throw new MatchException(null, null);
            case ExecutionPolicy.FIXED_RATE -> this.executor.scheduleAtFixedRate(this::run, startDelay, this.delay.toNanos(), TimeUnit.NANOSECONDS);
            case ExecutionPolicy.FIXED_DELAY -> this.executor.scheduleWithFixedDelay(this::run, startDelay, this.delay.toNanos(), TimeUnit.NANOSECONDS);
        };
        this.context = new ScheduleContext(this){
            final /* synthetic */ MultiTimeTaskImpl this$0;
            {
                MultiTimeTaskImpl multiTimeTaskImpl = this$0;
                Objects.requireNonNull(multiTimeTaskImpl);
                this.this$0 = multiTimeTaskImpl;
            }

            @Override
            public long runCount() {
                return this.this$0.runCount.get();
            }

            @Override
            public Instant nextRunTime() {
                if (this.this$0.scheduledFuture.isCancelled() || this.this$0.scheduledFuture.isDone()) {
                    return null;
                }
                return switch (this.this$0.executionPolicy) {
                    default -> throw new MatchException(null, null);
                    case ExecutionPolicy.FIXED_RATE -> this.this$0.initialScheduledTime.plus(this.this$0.delay.multipliedBy(this.this$0.runCount.get()));
                    case ExecutionPolicy.FIXED_DELAY -> {
                        Instant lastEnd = this.this$0.lastExecutionEndTime;
                        if (lastEnd != null) {
                            yield lastEnd.plus(this.this$0.delay);
                        }
                        yield this.this$0.initialScheduledTime;
                    }
                };
            }

            @Override
            public Instant nextRunTime(int count) {
                if (count <= 0) {
                    throw new IllegalArgumentException("count must be positive");
                }
                if (this.this$0.scheduledFuture.isCancelled() || this.this$0.scheduledFuture.isDone()) {
                    return null;
                }
                return switch (this.this$0.executionPolicy) {
                    default -> throw new MatchException(null, null);
                    case ExecutionPolicy.FIXED_RATE -> this.this$0.initialScheduledTime.plus(this.this$0.delay.multipliedBy(this.this$0.runCount.get() + (long)count));
                    case ExecutionPolicy.FIXED_DELAY -> {
                        Instant next = this.nextRunTime();
                        if (next != null) {
                            yield next.plus(this.this$0.delay.multipliedBy(count - 1));
                        }
                        yield null;
                    }
                };
            }

            @Override
            public void cancel() {
                this.this$0.scheduledFuture.cancel(false);
            }

            @Override
            public ScheduleStatus status() {
                Future.State s = this.this$0.scheduledFuture.state();
                return switch (s) {
                    default -> throw new MatchException(null, null);
                    case Future.State.RUNNING -> ScheduleStatus.RUNNING;
                    case Future.State.SUCCESS, Future.State.FAILED -> ScheduleStatus.DONE;
                    case Future.State.CANCELLED -> ScheduleStatus.CANCELLED;
                };
            }
        };
        return this.context;
    }

    private void run() {
        final long l = this.runCount.incrementAndGet();
        if (this.maxRunCount != -1L && l > this.maxRunCount) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            return;
        }
        try {
            this.task.apply((Object)new TaskContext(){
                final /* synthetic */ MultiTimeTaskImpl this$0;
                {
                    MultiTimeTaskImpl multiTimeTaskImpl = this$0;
                    Objects.requireNonNull(multiTimeTaskImpl);
                    this.this$0 = multiTimeTaskImpl;
                }

                @Override
                public long currentRunCount() {
                    return l;
                }

                @Override
                public ScheduleContext context() {
                    return this.this$0.context;
                }
            });
        }
        catch (Throwable e) {
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.accept(e);
                }
                catch (Throwable ex) {
                    e.addSuppressed(ex);
                    logger.log(System.Logger.Level.ERROR, "errorHandler \u53d1\u751f\u9519\u8bef !!!", e);
                }
            }
            logger.log(System.Logger.Level.ERROR, "\u8c03\u5ea6\u4efb\u52a1\u65f6\u53d1\u751f\u9519\u8bef !!!", e);
        }
        this.lastExecutionEndTime = Instant.now();
    }
}

