/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduling.cron;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import cool.scx.function.ConsumerX;
import cool.scx.scheduling.ScheduleContext;
import cool.scx.scheduling.ScheduleStatus;
import cool.scx.scheduling.TaskContext;
import cool.scx.scheduling.cron.CronTask;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class CronTaskImpl
implements CronTask {
    private static final System.Logger logger = System.getLogger(CronTaskImpl.class.getName());
    private static final CronParser CRON_PARSER = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private final AtomicLong runCount = new AtomicLong(0L);
    private final AtomicBoolean cancel = new AtomicBoolean(false);
    private ExecutionTime executionTime = null;
    private long maxRunCount = -1L;
    private ScheduledExecutorService executor = null;
    private ConsumerX<TaskContext, ?> task = null;
    private ZonedDateTime lastNext = null;
    private Consumer<Throwable> errorHandler = null;
    private ScheduleContext context = null;

    @Override
    public CronTask expression(String expression) {
        Cron cron = CRON_PARSER.parse(expression);
        this.executionTime = ExecutionTime.forCron((Cron)cron);
        return this;
    }

    @Override
    public CronTask maxRunCount(long maxRunCount) {
        this.maxRunCount = maxRunCount;
        return this;
    }

    @Override
    public CronTask executor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public CronTask task(ConsumerX<TaskContext, ?> task) {
        this.task = task;
        return this;
    }

    @Override
    public CronTask onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    public ScheduleContext start() {
        if (this.executor == null) {
            throw new IllegalStateException("executor \u672a\u8bbe\u7f6e !!!");
        }
        if (this.executionTime == null) {
            throw new IllegalStateException("execution \u672a\u8bbe\u7f6e !!!");
        }
        this.scheduleNext();
        this.context = new ScheduleContext(){

            @Override
            public long runCount() {
                return CronTaskImpl.this.runCount.get();
            }

            @Override
            public Instant nextRunTime() {
                return CronTaskImpl.this.lastNext != null ? CronTaskImpl.this.lastNext.toInstant() : null;
            }

            @Override
            public Instant nextRunTime(int count) {
                ZonedDateTime nextTime = CronTaskImpl.this.lastNext;
                for (int i = 0; i < count; ++i) {
                    nextTime = CronTaskImpl.this.executionTime.nextExecution(nextTime).orElse(null);
                }
                return nextTime != null ? nextTime.toInstant() : null;
            }

            @Override
            public void cancel() {
                CronTaskImpl.this.cancel.set(true);
            }

            @Override
            public ScheduleStatus status() {
                return CronTaskImpl.this.cancel.get() ? ScheduleStatus.CANCELLED : (CronTaskImpl.this.runCount.get() >= CronTaskImpl.this.maxRunCount ? ScheduleStatus.DONE : ScheduleStatus.RUNNING);
            }
        };
        return this.context;
    }

    private void scheduleNext() {
        ZonedDateTime now = ZonedDateTime.now();
        if (this.lastNext == null) {
            this.lastNext = now;
        }
        this.lastNext = this.executionTime.nextExecution(this.lastNext).orElse(null);
        if (this.lastNext == null) {
            return;
        }
        long delay = Duration.between(now, this.lastNext).toNanos();
        this.executor.schedule(this::run, delay, TimeUnit.NANOSECONDS);
    }

    private void run() {
        final long l = this.runCount.incrementAndGet();
        if (this.cancel.get() || this.maxRunCount != -1L && l > this.maxRunCount) {
            return;
        }
        this.scheduleNext();
        try {
            this.task.accept((Object)new TaskContext(){
                final /* synthetic */ CronTaskImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public long currentRunCount() {
                    return l;
                }

                @Override
                public ScheduleContext context() {
                    return this.this$0.context;
                }
            });
        }
        catch (Throwable e) {
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.accept(e);
                }
                catch (Throwable ex) {
                    e.addSuppressed(ex);
                    logger.log(System.Logger.Level.ERROR, "errorHandler \u53d1\u751f\u9519\u8bef !!!", e);
                }
            }
            logger.log(System.Logger.Level.ERROR, "\u8c03\u5ea6\u4efb\u52a1\u65f6\u53d1\u751f\u9519\u8bef !!!", e);
        }
    }
}

