/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduling.single_time;

import cool.scx.function.ConsumerX;
import cool.scx.scheduling.ExpirationPolicy;
import cool.scx.scheduling.ScheduleContext;
import cool.scx.scheduling.ScheduleStatus;
import cool.scx.scheduling.TaskContext;
import cool.scx.scheduling.single_time.SingleTimeTask;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class SingleTimeTaskImpl
implements SingleTimeTask {
    private static final System.Logger logger = System.getLogger(SingleTimeTaskImpl.class.getName());
    private final AtomicLong runCount = new AtomicLong(0L);
    private Supplier<Instant> startTimeSupplier = null;
    private ExpirationPolicy expirationPolicy = ExpirationPolicy.IMMEDIATE_COMPENSATION;
    private ScheduledExecutorService executor = null;
    private ConsumerX<TaskContext, ?> task = null;
    private ScheduleContext context = null;
    private Consumer<Throwable> errorHandler = null;

    @Override
    public SingleTimeTask startTime(Supplier<Instant> startTime) {
        this.startTimeSupplier = startTime;
        return this;
    }

    @Override
    public SingleTimeTask expirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
        return this;
    }

    @Override
    public SingleTimeTask executor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public SingleTimeTask task(ConsumerX<TaskContext, ?> task) {
        this.task = task;
        return this;
    }

    @Override
    public SingleTimeTask onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    public ScheduleContext start() {
        Duration between;
        Instant startTime;
        if (this.executor == null) {
            throw new IllegalStateException("Executor \u672a\u8bbe\u7f6e !!!");
        }
        Instant now = Instant.now();
        Instant instant = startTime = this.startTimeSupplier != null ? this.startTimeSupplier.get() : null;
        if (startTime == null) {
            startTime = now;
        }
        if ((between = Duration.between(now, startTime)).isNegative()) {
            switch (this.expirationPolicy) {
                case IMMEDIATE_IGNORE: 
                case BACKTRACKING_IGNORE: {
                    if (this.expirationPolicy == ExpirationPolicy.BACKTRACKING_IGNORE) {
                        this.runCount.incrementAndGet();
                    }
                    return new ScheduleContext(){

                        @Override
                        public long runCount() {
                            return SingleTimeTaskImpl.this.runCount.get();
                        }

                        @Override
                        public Instant nextRunTime() {
                            return null;
                        }

                        @Override
                        public Instant nextRunTime(int count) {
                            return null;
                        }

                        @Override
                        public void cancel() {
                        }

                        @Override
                        public ScheduleStatus status() {
                            return null;
                        }
                    };
                }
                case IMMEDIATE_COMPENSATION: 
                case BACKTRACKING_COMPENSATION: {
                    return this.doStart(0L);
                }
            }
            throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.expirationPolicy));
        }
        return this.doStart(between.toNanos());
    }

    private ScheduleContext doStart(long startDelay) {
        final Instant scheduledTime = Instant.now().plusNanos(startDelay);
        final ScheduledFuture<?> scheduledFuture = this.executor.schedule(this::run, startDelay, TimeUnit.NANOSECONDS);
        this.context = new ScheduleContext(){
            final /* synthetic */ SingleTimeTaskImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public long runCount() {
                return this.this$0.runCount.get();
            }

            @Override
            public Instant nextRunTime() {
                if (scheduledFuture.isCancelled()) {
                    return null;
                }
                if (this.runCount() > 0L) {
                    return null;
                }
                return scheduledTime;
            }

            @Override
            public Instant nextRunTime(int count) {
                return count == 1 ? this.nextRunTime() : null;
            }

            @Override
            public void cancel() {
                scheduledFuture.cancel(false);
            }

            @Override
            public ScheduleStatus status() {
                Future.State s = scheduledFuture.state();
                return switch (s) {
                    default -> throw new MatchException(null, null);
                    case Future.State.RUNNING -> ScheduleStatus.RUNNING;
                    case Future.State.SUCCESS, Future.State.FAILED -> ScheduleStatus.DONE;
                    case Future.State.CANCELLED -> ScheduleStatus.CANCELLED;
                };
            }
        };
        return this.context;
    }

    private void run() {
        final long l = this.runCount.incrementAndGet();
        try {
            this.task.accept((Object)new TaskContext(){
                final /* synthetic */ SingleTimeTaskImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public long currentRunCount() {
                    return l;
                }

                @Override
                public ScheduleContext context() {
                    return this.this$0.context;
                }
            });
        }
        catch (Throwable e) {
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.accept(e);
                }
                catch (Throwable ex) {
                    e.addSuppressed(ex);
                    logger.log(System.Logger.Level.ERROR, "errorHandler \u53d1\u751f\u9519\u8bef !!!", e);
                }
            }
            logger.log(System.Logger.Level.ERROR, "\u8c03\u5ea6\u4efb\u52a1\u65f6\u53d1\u751f\u9519\u8bef !!!", e);
        }
    }
}

