/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket_vertx;

import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket_vertx.ClearTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

final class DuplicateFrameChecker {
    final ConcurrentMap<Key, ClearTask> clearTaskMap = new ConcurrentHashMap<Key, ClearTask>();
    private final long clearTimeout;

    public DuplicateFrameChecker(long clearTimeout) {
        this.clearTimeout = clearTimeout;
    }

    public boolean check(ScxSocketFrame socketFrame) {
        if (!socketFrame.need_ack) {
            return true;
        }
        Key key = new Key(socketFrame.seq_id, socketFrame.now);
        AtomicBoolean notDuplicate = new AtomicBoolean();
        ClearTask task = this.clearTaskMap.compute(key, (k, v) -> {
            if (v == null) {
                notDuplicate.set(true);
                return new ClearTask(key, this);
            }
            notDuplicate.set(false);
            return v;
        });
        boolean b = notDuplicate.get();
        if (b) {
            task.start();
        }
        return b;
    }

    public void startAllClearTask() {
        for (ClearTask value : this.clearTaskMap.values()) {
            value.start();
        }
    }

    public void cancelAllClearTask() {
        for (ClearTask value : this.clearTaskMap.values()) {
            value.cancel();
        }
    }

    public long getClearTimeout() {
        return this.clearTimeout;
    }

    record Key(long seq_id, long now) {
    }
}

