/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket_vertx;

import cool.scx.socket_vertx.Helper;
import cool.scx.socket_vertx.PingPongManager;
import cool.scx.socket_vertx.ScxSocketServer;
import cool.scx.socket_vertx.ScxSocketStatus;
import io.netty.util.Timeout;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketBase;

public final class ScxServerSocket
extends PingPongManager {
    private final ScxSocketServer scxSocketServer;
    private Timeout removeClosedClientTimeout;

    ScxServerSocket(ServerWebSocket serverWebSocket, String clientID, ScxSocketServer scxSocketServer) {
        super((WebSocketBase)serverWebSocket, clientID, scxSocketServer.options);
        this.scxSocketServer = scxSocketServer;
    }

    ScxServerSocket(ServerWebSocket serverWebSocket, String clientID, ScxSocketServer scxSocketServer, ScxSocketStatus status) {
        super((WebSocketBase)serverWebSocket, clientID, scxSocketServer.options, status);
        this.scxSocketServer = scxSocketServer;
    }

    @Override
    protected void start() {
        super.start();
        this.cancelRemoveClosedClientTask();
    }

    @Override
    public void close() {
        this.startRemoveClosedClientTask();
        super.close();
    }

    private void startRemoveClosedClientTask() {
        this.cancelRemoveClosedClientTask();
        this.removeClosedClientTimeout = Helper.setTimeout(this::removeClosedClient, this.scxSocketServer.options.getStatusKeepTime());
    }

    private void cancelRemoveClosedClientTask() {
        if (this.removeClosedClientTimeout != null) {
            this.removeClosedClientTimeout.cancel();
            this.removeClosedClientTimeout = null;
        }
    }

    private void removeClosedClient() {
        this.scxSocketServer.serverSockets.remove(this.clientID);
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u5ba2\u6237\u7aef\u8d85\u65f6\u672a\u8fde\u63a5 \u5df2\u79fb\u9664", this.clientID);
        }
    }

    @Override
    protected void startPing() {
    }

    @Override
    protected void doPingTimeout() {
        this.close();
    }
}

