/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket_vertx;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import cool.scx.common.exception.ScxExceptionHelper;
import cool.scx.common.util.ObjectUtils;
import cool.scx.socket_vertx.URIBuilder;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class Helper {
    public static final String SCX_SOCKET_CLIENT_ID = "scx-socket-client-id";
    private static final ObjectMapper JSON_MAPPER = ObjectUtils.jsonMapper();
    private static final HashedWheelTimer HASHED_WHEEL_TIMER = new HashedWheelTimer();

    public static Timeout setTimeout(Runnable task, long delay) {
        return HASHED_WHEEL_TIMER.newTimeout(v -> task.run(), delay, TimeUnit.MILLISECONDS);
    }

    public static String getClientID(ServerWebSocket serverWebSocket) {
        QueryStringDecoder decoder = new QueryStringDecoder(serverWebSocket.uri());
        Map parameters = decoder.parameters();
        List clientIDValues = (List)parameters.get(SCX_SOCKET_CLIENT_ID);
        if (clientIDValues == null) {
            return null;
        }
        return clientIDValues.isEmpty() ? null : (String)clientIDValues.get(0);
    }

    public static WebSocketConnectOptions createConnectOptions(String absoluteURI, String clientID) {
        WebSocketConnectOptions o = new WebSocketConnectOptions().setAbsoluteURI(absoluteURI);
        String oldUri = o.getURI();
        String newUri = URIBuilder.of(oldUri).addParam(SCX_SOCKET_CLIENT_ID, clientID).toString();
        o.setURI(newUri);
        return o;
    }

    public static long getDelayed(int times) {
        return 1000L * (1L << times);
    }

    public static String toJson(Object data) {
        return (String)ScxExceptionHelper.wrap(() -> JSON_MAPPER.writeValueAsString(data));
    }

    public static <T> T fromJson(String json, Class<T> tClass) {
        return (T)(json == null ? null : ScxExceptionHelper.wrap(() -> JSON_MAPPER.readValue(json, tClass)));
    }

    public static <T> T fromJson(String json, TypeReference<T> valueTypeRef) {
        return (T)(json == null ? null : ScxExceptionHelper.wrap(() -> JSON_MAPPER.readValue(json, valueTypeRef)));
    }
}

