/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketHelper;
import cool.scx.socket.ScxSocketOptions;
import cool.scx.socket.SendOptions;
import cool.scx.socket.SendTask;
import cool.scx.socket.SeqIDClearTask;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import io.netty.util.Timeout;
import io.vertx.core.Future;
import io.vertx.core.http.WebSocketBase;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class ScxSocket {
    private static final ScxSocketFrame PING_FRAME = ScxSocket.createPingFrame();
    private static final ScxSocketFrame PONG_FRAME = ScxSocket.createPongFrame();
    protected final System.Logger logger = System.getLogger(this.getClass().getName());
    final ConcurrentMap<Long, SendTask> sendTaskMap;
    final ConcurrentMap<Long, SeqIDClearTask> seqIDClearTaskMap;
    private final ConcurrentMap<String, Consumer<String>> eventHandlerMap;
    private final ScxSocketOptions options;
    private final AtomicLong seqID;
    protected WebSocketBase webSocket;
    private Timeout ping;
    private Timeout pingTimeout;
    private Consumer<String> onMessage;
    private Consumer<Void> onClose;
    private Consumer<Throwable> onError;

    public ScxSocket(ScxSocketOptions options) {
        this.options = options;
        this.seqID = new AtomicLong(0L);
        this.sendTaskMap = new ConcurrentHashMap<Long, SendTask>();
        this.eventHandlerMap = new ConcurrentHashMap<String, Consumer<String>>();
        this.seqIDClearTaskMap = new ConcurrentHashMap<Long, SeqIDClearTask>();
    }

    private static ScxSocketFrame createAckFrame(long id) {
        ScxSocketFrame ackFrame = new ScxSocketFrame();
        ackFrame.seq_id = 0L;
        ackFrame.type = (byte)2;
        ackFrame.now = 0L;
        ackFrame.payload = Long.toString(id);
        return ackFrame;
    }

    private static ScxSocketFrame createPingFrame() {
        ScxSocketFrame pingFrame = new ScxSocketFrame();
        pingFrame.seq_id = 0L;
        pingFrame.type = (byte)3;
        pingFrame.now = 0L;
        pingFrame.payload = "";
        return pingFrame;
    }

    private static ScxSocketFrame createPongFrame() {
        ScxSocketFrame pongFrame = new ScxSocketFrame();
        pongFrame.seq_id = 0L;
        pongFrame.type = (byte)4;
        pongFrame.now = 0L;
        pongFrame.payload = "";
        return pongFrame;
    }

    private ScxSocketFrame createMessageFrame(String content, SendOptions options) {
        ScxSocketFrame messageFrame = new ScxSocketFrame();
        messageFrame.seq_id = this.seqID.getAndIncrement();
        messageFrame.type = options.getNeedAck() ? (byte)1 : 0;
        messageFrame.now = System.currentTimeMillis();
        messageFrame.payload = content;
        return messageFrame;
    }

    private ScxSocketFrame createEventFrame(String eventName, Object data, SendOptions options) {
        ScxSocketFrame eventFrame = new ScxSocketFrame();
        eventFrame.seq_id = this.seqID.getAndIncrement();
        eventFrame.type = options.getNeedAck() ? (byte)1 : 0;
        eventFrame.now = System.currentTimeMillis();
        eventFrame.event_name = eventName;
        eventFrame.payload = ObjectUtils.toJson((Object)data, (String)"", (ObjectUtils.Option[])new ObjectUtils.Option[0]);
        return eventFrame;
    }

    private void send(ScxSocketFrame socketFrame, SendOptions options) {
        SendTask sendTask = new SendTask(socketFrame, this, options);
        this.sendTaskMap.put(socketFrame.seq_id, sendTask);
        sendTask.start();
    }

    public void send(String content) {
        this.send(this.createMessageFrame(content, SendOptions.DEFAULT_SEND_OPTIONS), SendOptions.DEFAULT_SEND_OPTIONS);
    }

    public void send(String content, SendOptions options) {
        this.send(this.createMessageFrame(content, options), options);
    }

    public void sendEvent(String eventName, Object data) {
        this.send(this.createEventFrame(eventName, data, SendOptions.DEFAULT_SEND_OPTIONS), SendOptions.DEFAULT_SEND_OPTIONS);
    }

    public void sendEvent(String eventName, Object data, SendOptions options) {
        this.send(this.createEventFrame(eventName, data, options), options);
    }

    private void sendAck(long id) {
        this.webSocket.writeTextMessage(ScxSocket.createAckFrame(id).toJson());
    }

    private Future<Void> sendPing() {
        return this.webSocket.writeTextMessage(PING_FRAME.toJson());
    }

    protected void sendPong() {
        this.webSocket.writeTextMessage(PONG_FRAME.toJson());
    }

    private void startAllSendTask() {
        for (SendTask value : this.sendTaskMap.values()) {
            value.start();
        }
    }

    private void cancelAllResendTask() {
        for (SendTask value : this.sendTaskMap.values()) {
            value.cancelResend();
        }
    }

    private void startAllSendTaskAsync() {
        Thread.ofVirtual().start(this::startAllSendTask);
    }

    private void cancelAllResendTaskAsync() {
        Thread.ofVirtual().start(this::cancelAllResendTask);
    }

    private void bind(WebSocketBase webSocket) {
        this.webSocket = webSocket;
        this.webSocket.textMessageHandler(t -> this.doSocketFrame(ScxSocketFrame.fromJson(t)));
        this.webSocket.closeHandler(this::doClose);
        this.webSocket.exceptionHandler(this::doError);
    }

    private void removeBind() {
        if (this.webSocket != null && !this.webSocket.isClosed()) {
            this.webSocket.textMessageHandler(null);
            this.webSocket.closeHandler(null);
            this.webSocket.exceptionHandler(null);
        }
    }

    protected void doSocketFrame(ScxSocketFrame socketFrame) {
        this.startPing();
        this.startPingTimeout();
        switch (socketFrame.type) {
            case 0: {
                this.doMessage(socketFrame);
                break;
            }
            case 1: {
                this.doMessageNeedAck(socketFrame);
                break;
            }
            case 2: {
                this.doAck(socketFrame);
                break;
            }
            case 3: {
                this.doPing(socketFrame);
                break;
            }
            case 4: {
                this.doPong(socketFrame);
            }
        }
    }

    private void doMessage(ScxSocketFrame socketFrame) {
        if (StringUtils.isBlank((String)socketFrame.event_name)) {
            this.callOnMessageWithCheckDuplicateAsync(socketFrame);
        } else {
            this.callOnEventWithCheckDuplicateAsync(socketFrame);
        }
    }

    private void doMessageNeedAck(ScxSocketFrame socketFrame) {
        this.sendAck(socketFrame.seq_id);
        this.doMessage(socketFrame);
    }

    protected void doAck(ScxSocketFrame ackFrame) {
        long seqID = Long.parseLong(ackFrame.payload);
        SendTask sendTask = (SendTask)this.sendTaskMap.get(seqID);
        if (sendTask != null) {
            sendTask.clear();
        }
    }

    private void doPing(ScxSocketFrame socketFrame) {
        this.sendPong();
        this.logger.log(System.Logger.Level.DEBUG, "\u6536\u5230 ping");
    }

    private void doPong(ScxSocketFrame socketFrame) {
        this.logger.log(System.Logger.Level.DEBUG, "\u6536\u5230 pong");
    }

    protected void doClose(Void v) {
        this.close();
        this.callOnClose(v);
    }

    protected void doError(Throwable e) {
        this.close();
        this.callOnError(e);
    }

    private void closeWebSocket() {
        if (this.webSocket != null && !this.webSocket.isClosed()) {
            this.webSocket.close();
        }
    }

    private void startPingTimeout() {
        this.cancelPingTimeout();
        this.pingTimeout = ScxSocketHelper.setTimeout(this::doPingTimeout, this.options.getPingTimeout() + this.options.getPingInterval());
    }

    private void cancelPingTimeout() {
        if (this.pingTimeout != null) {
            this.pingTimeout.cancel();
            this.pingTimeout = null;
        }
    }

    protected void startPing() {
        this.cancelPing();
        this.ping = ScxSocketHelper.setTimeout(() -> {
            this.sendPing();
            this.startPing();
        }, this.options.getPingInterval());
    }

    private void cancelPing() {
        if (this.ping != null) {
            this.ping.cancel();
            this.ping = null;
        }
    }

    void start(WebSocketBase webSocket) {
        this.close();
        this.bind(webSocket);
        this.startAllSendTask();
        this.startPing();
        this.startPingTimeout();
        this.startAllClearTask();
    }

    public void close() {
        this.removeBind();
        this.closeWebSocket();
        this.cancelAllResendTask();
        this.cancelPing();
        this.cancelPingTimeout();
        this.cancelAllClearTask();
    }

    protected void doPingTimeout() {
        this.close();
    }

    public boolean isClosed() {
        return this.webSocket == null || this.webSocket.isClosed();
    }

    public ScxSocket onMessage(Consumer<String> onMessage) {
        this.onMessage = onMessage;
        return this;
    }

    public ScxSocket onClose(Consumer<Void> onClose) {
        this.onClose = onClose;
        return this;
    }

    public ScxSocket onError(Consumer<Throwable> onError) {
        this.onError = onError;
        return this;
    }

    public ScxSocket onEvent(String eventName, Consumer<String> onEvent) {
        this.eventHandlerMap.put(eventName, onEvent);
        return this;
    }

    public <T> ScxSocket onEvent(String eventName, Class<T> dataClass, Consumer<T> onEvent) {
        this.eventHandlerMap.put(eventName, s -> onEvent.accept(ScxSocketHelper.fromJson(s, dataClass)));
        return this;
    }

    private void callOnMessage(String message) {
        if (this.onMessage != null) {
            this.onMessage.accept(message);
        }
    }

    private void callOnMessage(ScxSocketFrame socketFrame) {
        if (this.onMessage != null) {
            this.onMessage.accept(socketFrame.payload);
        }
    }

    private void callOnMessageWithCheckDuplicate(ScxSocketFrame socketFrame) {
        if (this.onMessage != null && this.checkDuplicate(socketFrame)) {
            this.onMessage.accept(socketFrame.payload);
        }
    }

    private void callOnClose(Void v) {
        if (this.onClose != null) {
            this.onClose.accept(v);
        }
    }

    private void callOnError(Throwable e) {
        if (this.onError != null) {
            this.onError.accept(e);
        }
    }

    private void callOnEvent(String eventName, String data) {
        Consumer eventHandler = (Consumer)this.eventHandlerMap.get(eventName);
        if (eventHandler != null) {
            eventHandler.accept(data);
        }
    }

    private void callOnEvent(ScxSocketFrame socketFrame) {
        Consumer eventHandler = (Consumer)this.eventHandlerMap.get(socketFrame.event_name);
        if (eventHandler != null) {
            eventHandler.accept(socketFrame.payload);
        }
    }

    private void callOnEventWithCheckDuplicate(ScxSocketFrame socketFrame) {
        Consumer eventHandler = (Consumer)this.eventHandlerMap.get(socketFrame.event_name);
        if (eventHandler != null && this.checkDuplicate(socketFrame)) {
            eventHandler.accept(socketFrame.payload);
        }
    }

    private void callOnMessageAsync(String message) {
        if (this.onMessage != null) {
            Thread.ofVirtual().start(() -> this.onMessage.accept(message));
        }
    }

    private void callOnMessageAsync(ScxSocketFrame socketFrame) {
        if (this.onMessage != null) {
            Thread.ofVirtual().start(() -> this.onMessage.accept(socketFrame.payload));
        }
    }

    private void callOnMessageWithCheckDuplicateAsync(ScxSocketFrame socketFrame) {
        if (this.onMessage != null && this.checkDuplicate(socketFrame)) {
            Thread.ofVirtual().start(() -> this.onMessage.accept(socketFrame.payload));
        }
    }

    private void callOnCloseAsync(Void v) {
        if (this.onClose != null) {
            Thread.ofVirtual().start(() -> this.onClose.accept(v));
        }
    }

    private void callOnErrorAsync(Throwable e) {
        if (this.onError != null) {
            Thread.ofVirtual().start(() -> this.onError.accept(e));
        }
    }

    private void callOnEventAsync(String eventName, String data) {
        Consumer eventHandler = (Consumer)this.eventHandlerMap.get(eventName);
        if (eventHandler != null) {
            Thread.ofVirtual().start(() -> eventHandler.accept(data));
        }
    }

    private void callOnEventAsync(ScxSocketFrame socketFrame) {
        Consumer eventHandler = (Consumer)this.eventHandlerMap.get(socketFrame.event_name);
        if (eventHandler != null) {
            Thread.ofVirtual().start(() -> eventHandler.accept(socketFrame.payload));
        }
    }

    private void callOnEventWithCheckDuplicateAsync(ScxSocketFrame socketFrame) {
        Consumer eventHandler = (Consumer)this.eventHandlerMap.get(socketFrame.event_name);
        if (eventHandler != null && this.checkDuplicate(socketFrame)) {
            Thread.ofVirtual().start(() -> eventHandler.accept(socketFrame.payload));
        }
    }

    private boolean checkDuplicate(ScxSocketFrame socketFrame) {
        if (socketFrame.type != 1) {
            return true;
        }
        long seqID = socketFrame.seq_id;
        SeqIDClearTask task = (SeqIDClearTask)this.seqIDClearTaskMap.get(seqID);
        if (task == null) {
            SeqIDClearTask seqIDClearTask = new SeqIDClearTask(seqID, this);
            this.seqIDClearTaskMap.put(seqID, seqIDClearTask);
            seqIDClearTask.start();
            return true;
        }
        return false;
    }

    private void startAllClearTask() {
        for (SeqIDClearTask value : this.seqIDClearTaskMap.values()) {
            value.start();
        }
    }

    private void cancelAllClearTask() {
        for (SeqIDClearTask value : this.seqIDClearTaskMap.values()) {
            value.cancel();
        }
    }

    private void startAllClearTaskAsync() {
        Thread.ofVirtual().start(this::startAllClearTask);
    }

    private void cancelAllClearTaskAsync() {
        Thread.ofVirtual().start(this::cancelAllClearTaskAsync);
    }
}

