/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.ScxSocket;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketHelper;
import cool.scx.socket.SendOptions;
import io.netty.util.Timeout;
import io.vertx.core.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public final class SendTask {
    private final ScxSocketFrame socketFrame;
    private final ScxSocket scxSocket;
    private final SendOptions options;
    private final AtomicInteger sendTimes = new AtomicInteger(0);
    private Timeout resendThread;
    private Future<Void> sendFuture;
    private Consumer<Void> _onSendSuccess;
    private Consumer<Throwable> _onSendFailure;

    public SendTask(ScxSocketFrame socketFrame, ScxSocket scxSocket, SendOptions options) {
        this.socketFrame = socketFrame;
        this.scxSocket = scxSocket;
        this.options = options;
    }

    private static long getDelayed(int times) {
        return 1000L * (1L << times);
    }

    public void start() {
        if (this.scxSocket.isClosed()) {
            return;
        }
        if (this.sendFuture != null && !this.sendFuture.isComplete()) {
            return;
        }
        if (this.sendTimes.get() > this.options.getMaxResendTimes()) {
            if (this.options.getGiveUpIfReachMaxResendTimes()) {
                this.clear();
            }
            return;
        }
        this.sendFuture = this.scxSocket.webSocket.writeTextMessage(this.socketFrame.toJson());
        this._setConnectFuture();
        this.sendFuture.onSuccess(this::_onSendSuccess).onFailure(this::_onSendFailure);
    }

    public void cancelResend() {
        this._removeConnectFuture();
        if (this.resendThread != null) {
            this.resendThread.cancel();
            this.resendThread = null;
        }
    }

    public void clear() {
        this.cancelResend();
        this.scxSocket.sendTaskMap.remove(this.socketFrame.seq_id);
    }

    public ScxSocketFrame socketFrame() {
        return this.socketFrame;
    }

    private void _onSendSuccess(Void v) {
        if (this._onSendSuccess != null) {
            this._onSendSuccess.accept(v);
        }
    }

    private void _onSendFailure(Throwable throwable) {
        if (this._onSendFailure != null) {
            this._onSendFailure.accept(throwable);
        }
    }

    private void _setConnectFuture() {
        this._onSendSuccess = webSocket -> {
            int currentSendTime = this.sendTimes.getAndIncrement();
            if (this.options.getNeedAck()) {
                this.resendThread = ScxSocketHelper.setTimeout(this::start, Math.max(SendTask.getDelayed(currentSendTime), this.options.getMaxResendDelayed()));
            } else {
                this.clear();
            }
        };
        this._onSendFailure = v -> {};
    }

    private void _removeConnectFuture() {
        this._onSendSuccess = null;
        this._onSendFailure = null;
    }
}

