package cool.scx.socket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import cool.scx.util.ObjectUtils;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;

import java.util.concurrent.TimeUnit;

final class ScxSocketHelper {

    public static final String SCX_SOCKET_CLIENT_ID_KEY = "scx-socket-client-id";

    static final ObjectMapper JSON_MAPPER = ObjectUtils.jsonMapper();

    private static final HashedWheelTimer HASHED_WHEEL_TIMER = new HashedWheelTimer(Thread.ofVirtual().factory());

    public static Timeout setTimeout(Runnable task, long delay) {
        return HASHED_WHEEL_TIMER.newTimeout((v) -> task.run(), delay, TimeUnit.MILLISECONDS);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return JSON_MAPPER.readValue(json, clazz);
        } catch (JsonProcessingException ignored) {
            return null;
        }
    }

}
