package cool.scx.socket;

import io.netty.util.Timeout;

import static cool.scx.socket.ScxSocketHelper.setTimeout;

public final class SeqIDClearTask {

    private final ScxSocket scxSocket;
    private final long seqID;
    private Timeout clearTimeout;

    public SeqIDClearTask(long seqID, ScxSocket scxSocket) {
        this.seqID = seqID;
        this.scxSocket = scxSocket;
    }

    public void start() {
        cancel();
        clearTimeout = setTimeout(this::clear, scxSocket.options.getSeqIDClearTimeout());
    }

    public void cancel() {
        if (clearTimeout != null) {
            clearTimeout.cancel();
            clearTimeout = null;
        }
    }

    private void clear() {
        scxSocket.seqIDClearTaskMap.remove(seqID);
    }

}
