/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.ScxSocket;
import cool.scx.socket.ScxSocketClientOptions;
import cool.scx.socket.ScxSocketHelper;
import cool.scx.util.RandomUtils;
import cool.scx.util.URIBuilder;
import io.netty.util.Timeout;
import io.vertx.core.Future;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketConnectOptions;
import java.util.function.Consumer;

public final class ScxSocketClient
extends ScxSocket {
    private final WebSocketConnectOptions connectOptions;
    private final WebSocketClient webSocketClient;
    private final String clientID;
    private final ScxSocketClientOptions clientOptions;
    private Timeout reconnectTimeout;
    private Future<WebSocket> connectFuture;
    private Consumer<Void> onOpen;
    private Consumer<WebSocket> _onConnectSuccess;
    private Consumer<Throwable> _onConnectFailure;

    public ScxSocketClient(String uri, WebSocketClient webSocketClient, String clientID, ScxSocketClientOptions clientOptions) {
        super(clientOptions);
        this.clientOptions = clientOptions;
        this.webSocketClient = webSocketClient;
        this.clientID = clientID;
        this.connectOptions = ScxSocketClient.initConnectOptions(uri, this.clientID);
    }

    public ScxSocketClient(String uri, WebSocketClient webSocketClient, ScxSocketClientOptions options) {
        this(uri, webSocketClient, RandomUtils.randomUUID(), options);
    }

    public ScxSocketClient(String uri, WebSocketClient webSocketClient, String clientID) {
        this(uri, webSocketClient, clientID, new ScxSocketClientOptions());
    }

    public ScxSocketClient(String uri, WebSocketClient webSocketClient) {
        this(uri, webSocketClient, RandomUtils.randomUUID(), new ScxSocketClientOptions());
    }

    private static WebSocketConnectOptions initConnectOptions(String uri, String clientID) {
        WebSocketConnectOptions o = new WebSocketConnectOptions().setAbsoluteURI(uri);
        String oldUri = o.getURI();
        String newUri = URIBuilder.of((String)oldUri).addParam("scx-socket-client-id", (Object)clientID).toString();
        o.setURI(newUri);
        return o;
    }

    private void _onConnectSuccess(WebSocket webSocket) {
        if (this._onConnectSuccess != null) {
            this._onConnectSuccess.accept(webSocket);
        }
    }

    private void _onConnectFailure(Throwable throwable) {
        if (this._onConnectFailure != null) {
            this._onConnectFailure.accept(throwable);
        }
    }

    private void _setConnectFuture() {
        this._onConnectSuccess = webSocket -> {
            this.start((WebSocketBase)webSocket);
            this.doOpen();
        };
        this._onConnectFailure = v -> this.reconnect();
    }

    private void _removeConnectFuture() {
        this._onConnectSuccess = null;
        this._onConnectFailure = null;
    }

    public ScxSocketClient onOpen(Consumer<Void> onOpen) {
        this.onOpen = onOpen;
        return this;
    }

    private void cancelReconnect() {
        if (this.reconnectTimeout != null) {
            this.reconnectTimeout.cancel();
            this.reconnectTimeout = null;
        }
    }

    public void connect() {
        if (this.connectFuture != null && !this.connectFuture.isComplete()) {
            return;
        }
        this.close();
        this._setConnectFuture();
        this.connectFuture = this.webSocketClient.connect(this.connectOptions);
        this.connectFuture.onSuccess(this::_onConnectSuccess).onFailure(this::_onConnectFailure);
    }

    private void doOpen() {
        this.callOnOpen(null);
    }

    @Override
    protected void doClose(Void unused) {
        super.doClose(unused);
        this.connect();
    }

    @Override
    protected void doError(Throwable e) {
        super.doError(e);
        this.connect();
    }

    private void reconnect() {
        if (this.reconnectTimeout != null) {
            return;
        }
        this.logger.log(System.Logger.Level.DEBUG, "WebSocket \u91cd\u8fde\u4e2d... ");
        this.reconnectTimeout = ScxSocketHelper.setTimeout(() -> {
            this.reconnectTimeout = null;
            this.connect();
        }, this.clientOptions.getReconnectTimeout());
    }

    @Override
    public void close() {
        this._removeConnectFuture();
        this.cancelReconnect();
        super.close();
    }

    public String clientID() {
        return this.clientID;
    }

    @Override
    protected void doPingTimeout() {
        this.connect();
    }

    private void callOnOpen(Void v) {
        if (this.onOpen != null) {
            this.onOpen.accept(v);
        }
    }

    private void callOnOpenAsync(Void v) {
        if (this.onOpen != null) {
            Thread.ofVirtual().start(() -> this.onOpen.accept(v));
        }
    }
}

