/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.ScxSocket;
import cool.scx.socket.ScxSocketHelper;
import cool.scx.socket.ScxSocketServer;
import cool.scx.socket.ScxSocketServerOptions;
import io.netty.util.Timeout;
import io.vertx.core.http.WebSocketBase;

public final class ScxSocketClientConnect
extends ScxSocket {
    private final String clientID;
    private final ScxSocketServer scxSocketServer;
    private final ScxSocketServerOptions serverOptions;
    private Timeout removeClosedClientTimeout;

    public ScxSocketClientConnect(String clientID, ScxSocketServerOptions serverOptions, ScxSocketServer scxSocketServer) {
        super(serverOptions);
        this.clientID = clientID;
        this.serverOptions = serverOptions;
        this.scxSocketServer = scxSocketServer;
    }

    public String clientID() {
        return this.clientID;
    }

    @Override
    void start(WebSocketBase webSocket) {
        super.start(webSocket);
        this.cancelRemoveClosedClientTask();
    }

    @Override
    public void close() {
        super.close();
        this.startRemoveClosedClientTask();
    }

    private void startRemoveClosedClientTask() {
        this.cancelRemoveClosedClientTask();
        this.removeClosedClientTimeout = ScxSocketHelper.setTimeout(this::removeClosedClient, this.serverOptions.getRemoveClosedClientTimeout());
    }

    private void cancelRemoveClosedClientTask() {
        if (this.removeClosedClientTimeout != null) {
            this.removeClosedClientTimeout.cancel();
            this.removeClosedClientTimeout = null;
        }
    }

    private void removeClosedClient() {
        this.scxSocketServer.clientConnectMap.remove(this.clientID);
    }

    @Override
    protected void startPing() {
    }
}

