/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.SeqIDClearTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DuplicateFrameChecker {
    final ConcurrentMap<Long, SeqIDClearTask> seqIDClearTaskMap = new ConcurrentHashMap<Long, SeqIDClearTask>();
    final long seqIDClearTimeout;

    public DuplicateFrameChecker(long seqIDClearTimeout) {
        this.seqIDClearTimeout = seqIDClearTimeout;
    }

    public boolean checkDuplicate(ScxSocketFrame socketFrame) {
        if (!socketFrame.need_ack) {
            return true;
        }
        long seqID = socketFrame.seq_id;
        SeqIDClearTask task = (SeqIDClearTask)this.seqIDClearTaskMap.get(seqID);
        if (task == null) {
            SeqIDClearTask seqIDClearTask = new SeqIDClearTask(seqID, this);
            this.seqIDClearTaskMap.put(seqID, seqIDClearTask);
            seqIDClearTask.start();
            return true;
        }
        return false;
    }

    public void startAllClearTask() {
        for (SeqIDClearTask value : this.seqIDClearTaskMap.values()) {
            value.start();
        }
    }

    public void cancelAllClearTask() {
        for (SeqIDClearTask value : this.seqIDClearTaskMap.values()) {
            value.cancel();
        }
    }

    public void startAllClearTaskAsync() {
        Thread.ofVirtual().start(this::startAllClearTask);
    }

    public void cancelAllClearTaskAsync() {
        Thread.ofVirtual().start(this::cancelAllClearTaskAsync);
    }

    public long getSeqIDClearTimeout() {
        return this.seqIDClearTimeout;
    }
}

