/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import com.fasterxml.jackson.databind.ObjectMapper;
import cool.scx.util.ObjectUtils;
import cool.scx.util.URIBuilder;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

final class ScxSocketHelper {
    public static final String SCX_SOCKET_CLIENT_ID_KEY = "scx-socket-client-id";
    static final ObjectMapper JSON_MAPPER = ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]);
    private static final HashedWheelTimer HASHED_WHEEL_TIMER = new HashedWheelTimer(Thread.ofVirtual().factory());

    ScxSocketHelper() {
    }

    public static Timeout setTimeout(Runnable task, long delay) {
        return HASHED_WHEEL_TIMER.newTimeout(v -> task.run(), delay, TimeUnit.MILLISECONDS);
    }

    public static String getClientID(ServerWebSocket serverWebSocket) {
        QueryStringDecoder decoder = new QueryStringDecoder(serverWebSocket.uri());
        Map parameters = decoder.parameters();
        List clientIDValues = (List)parameters.get(SCX_SOCKET_CLIENT_ID_KEY);
        return clientIDValues.isEmpty() ? null : (String)clientIDValues.get(0);
    }

    public static WebSocketConnectOptions initConnectOptions(String uri, String clientID) {
        WebSocketConnectOptions o = new WebSocketConnectOptions().setAbsoluteURI(uri);
        String oldUri = o.getURI();
        String newUri = URIBuilder.of((String)oldUri).addParam(SCX_SOCKET_CLIENT_ID_KEY, (Object)clientID).toString();
        o.setURI(newUri);
        return o;
    }

    public static long getDelayed(int times) {
        return 1000L * (1L << times);
    }
}

