/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.DuplicateFrameChecker;
import cool.scx.socket.ScxSocketHelper;
import io.netty.util.Timeout;

public final class SeqIDClearTask {
    private final DuplicateFrameChecker checker;
    private final long seqID;
    private Timeout clearTimeout;

    public SeqIDClearTask(long seqID, DuplicateFrameChecker checker) {
        this.seqID = seqID;
        this.checker = checker;
    }

    public void start() {
        this.cancel();
        this.clearTimeout = ScxSocketHelper.setTimeout(this::clear, this.checker.getSeqIDClearTimeout());
    }

    public void cancel() {
        if (this.clearTimeout != null) {
            this.clearTimeout.cancel();
            this.clearTimeout = null;
        }
    }

    private void clear() {
        this.checker.seqIDClearTaskMap.remove(this.seqID);
    }
}

