/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.DuplicateFrameKey;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.SeqIDClearTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DuplicateFrameChecker {
    final ConcurrentMap<DuplicateFrameKey, SeqIDClearTask> seqIDClearTaskMap = new ConcurrentHashMap<DuplicateFrameKey, SeqIDClearTask>();
    final long seqIDClearTimeout;

    public DuplicateFrameChecker(long seqIDClearTimeout) {
        this.seqIDClearTimeout = seqIDClearTimeout;
    }

    public boolean checkDuplicate(ScxSocketFrame socketFrame) {
        if (!socketFrame.need_ack) {
            return true;
        }
        DuplicateFrameKey key = new DuplicateFrameKey(socketFrame.seq_id, socketFrame.now);
        SeqIDClearTask task = (SeqIDClearTask)this.seqIDClearTaskMap.get(key);
        if (task == null) {
            SeqIDClearTask seqIDClearTask = new SeqIDClearTask(key, this);
            this.seqIDClearTaskMap.put(key, seqIDClearTask);
            seqIDClearTask.start();
            return true;
        }
        return false;
    }

    public void startAllClearTask() {
        for (SeqIDClearTask value : this.seqIDClearTaskMap.values()) {
            value.start();
        }
    }

    public void cancelAllClearTask() {
        for (SeqIDClearTask value : this.seqIDClearTaskMap.values()) {
            value.cancel();
        }
    }

    public void startAllClearTaskAsync() {
        Thread.ofVirtual().start(this::startAllClearTask);
    }

    public void cancelAllClearTaskAsync() {
        Thread.ofVirtual().start(this::cancelAllClearTaskAsync);
    }

    public long getSeqIDClearTimeout() {
        return this.seqIDClearTimeout;
    }
}

