/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.FrameCreator;
import cool.scx.socket.ScxSocket;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketHelper;
import cool.scx.socket.ScxSocketOptions;
import io.netty.util.Timeout;
import io.vertx.core.Future;
import io.vertx.core.http.WebSocketBase;

public abstract class PingPongManager
extends ScxSocket {
    private Timeout ping;
    private Timeout pingTimeout;

    public PingPongManager(ScxSocketOptions options) {
        super(options);
    }

    private void startPingTimeout() {
        this.cancelPingTimeout();
        this.pingTimeout = ScxSocketHelper.setTimeout(this::doPingTimeout, this.options.getPingTimeout() + this.options.getPingInterval());
    }

    private void cancelPingTimeout() {
        if (this.pingTimeout != null) {
            this.pingTimeout.cancel();
            this.pingTimeout = null;
        }
    }

    protected void startPing() {
        this.cancelPing();
        this.ping = ScxSocketHelper.setTimeout(() -> {
            this.sendPing();
            this.startPing();
        }, this.options.getPingInterval());
    }

    private void cancelPing() {
        if (this.ping != null) {
            this.ping.cancel();
            this.ping = null;
        }
    }

    @Override
    protected void doSocketFrame(ScxSocketFrame socketFrame) {
        this.startPing();
        this.startPingTimeout();
        switch (socketFrame.type) {
            case 3: {
                this.doPing(socketFrame);
                break;
            }
            case 4: {
                this.doPong(socketFrame);
                break;
            }
            default: {
                super.doSocketFrame(socketFrame);
            }
        }
    }

    @Override
    void start(WebSocketBase webSocket) {
        super.start(webSocket);
        this.startPing();
        this.startPingTimeout();
    }

    @Override
    public void close() {
        super.close();
        this.cancelPing();
        this.cancelPingTimeout();
    }

    private Future<Void> sendPing() {
        return this.webSocket.writeTextMessage(FrameCreator.PING_FRAME.toJson());
    }

    private void sendPong() {
        Future sendPongFuture = this.webSocket.writeTextMessage(FrameCreator.PONG_FRAME.toJson());
        sendPongFuture.onSuccess(v -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "\u53d1\u9001 pong \u6210\u529f : {0}", FrameCreator.PONG_FRAME.toJson());
            }
        }).onFailure(c -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "\u53d1\u9001 pong \u5931\u8d25: {0}", FrameCreator.PONG_FRAME.toJson(), c);
            }
        });
    }

    private void doPing(ScxSocketFrame socketFrame) {
        this.sendPong();
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "\u6536\u5230 ping : {0}", socketFrame.toJson());
        }
    }

    private void doPong(ScxSocketFrame socketFrame) {
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "\u6536\u5230 pong : {0}", socketFrame.toJson());
        }
    }

    protected abstract void doPingTimeout();
}

