/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.ScxSocketClientConnect;
import cool.scx.socket.ScxSocketHelper;
import cool.scx.socket.ScxSocketServerOptions;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketBase;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public final class ScxSocketServer {
    final ConcurrentMap<String, ScxSocketClientConnect> clientConnectMap;
    final ScxSocketServerOptions options;
    private Consumer<ScxSocketClientConnect> onClientConnect;

    public ScxSocketServer() {
        this(new ScxSocketServerOptions());
    }

    public ScxSocketServer(ScxSocketServerOptions options) {
        this.options = options;
        this.clientConnectMap = new ConcurrentHashMap<String, ScxSocketClientConnect>();
    }

    public void onClientConnect(Consumer<ScxSocketClientConnect> onClientConnect) {
        this.onClientConnect = onClientConnect;
    }

    public ScxSocketClientConnect getClient(String clientID) {
        return (ScxSocketClientConnect)this.clientConnectMap.get(clientID);
    }

    public ScxSocketClientConnect getOrCreateClient(String clientID) {
        return this.clientConnectMap.computeIfAbsent(clientID, k -> new ScxSocketClientConnect(clientID, this.options, this));
    }

    public Collection<ScxSocketClientConnect> getClients() {
        return this.clientConnectMap.values();
    }

    public void call(ServerWebSocket serverWebSocket) {
        String clientID = ScxSocketHelper.getClientID(serverWebSocket);
        if (clientID == null) {
            serverWebSocket.reject(400);
        }
        ScxSocketClientConnect clientConnect = this.getOrCreateClient(clientID);
        clientConnect.start((WebSocketBase)serverWebSocket);
        this.callOnClientConnectAsync(clientConnect);
    }

    private void callOnClientConnect(ScxSocketClientConnect clientConnect) {
        if (this.onClientConnect != null) {
            this.onClientConnect.accept(clientConnect);
        }
    }

    private void callOnClientConnectAsync(ScxSocketClientConnect clientConnect) {
        if (this.onClientConnect != null) {
            Thread.ofVirtual().start(() -> this.onClientConnect.accept(clientConnect));
        }
    }
}

