/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.FutureHelper;
import cool.scx.socket.ScxSocket;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketHelper;
import cool.scx.socket.SendOptions;
import io.netty.util.Timeout;
import java.util.concurrent.atomic.AtomicInteger;

public final class SendTask {
    private static final System.Logger logger = System.getLogger(SendTask.class.getName());
    private final ScxSocketFrame socketFrame;
    private final SendOptions options;
    private final ScxSocket scxSocket;
    private final AtomicInteger sendTimes;
    private Timeout resendThread;
    private FutureHelper<Void> sendFuture;

    public SendTask(ScxSocketFrame socketFrame, SendOptions options, ScxSocket scxSocket) {
        this.socketFrame = socketFrame;
        this.options = options;
        this.scxSocket = scxSocket;
        this.sendTimes = new AtomicInteger(0);
    }

    public void start() {
        if (this.scxSocket.isClosed()) {
            return;
        }
        if (this.sendFuture != null && !this.sendFuture.isComplete()) {
            return;
        }
        if (this.sendTimes.get() > this.options.getMaxResendTimes()) {
            if (this.options.getGiveUpIfReachMaxResendTimes()) {
                this.clear();
            }
            return;
        }
        this.sendFuture = new FutureHelper(this.scxSocket.webSocket.writeTextMessage(this.socketFrame.toJson()));
        this.sendFuture.onSuccess(webSocket -> {
            int currentSendTime = this.sendTimes.getAndIncrement();
            if (this.options.getNeedAck()) {
                this.resendThread = ScxSocketHelper.setTimeout(this::start, Math.max(ScxSocketHelper.getDelayed(currentSendTime), this.options.getMaxResendDelayed()));
            } else {
                this.clear();
            }
            if (logger.isLoggable(System.Logger.Level.DEBUG)) {
                logger.log(System.Logger.Level.DEBUG, "\u53d1\u9001\u6210\u529f : {0}", this.socketFrame.toJson());
            }
        }).onFailure(v -> {
            if (logger.isLoggable(System.Logger.Level.DEBUG)) {
                logger.log(System.Logger.Level.DEBUG, "\u53d1\u9001\u5931\u8d25 : {0}", this.socketFrame.toJson(), v);
            }
        });
    }

    public void cancelResend() {
        this.removeConnectFuture();
        if (this.resendThread != null) {
            this.resendThread.cancel();
            this.resendThread = null;
        }
    }

    public void clear() {
        this.cancelResend();
        this.scxSocket.sendTaskMap.remove(this.socketFrame.seq_id);
    }

    public ScxSocketFrame socketFrame() {
        return this.socketFrame;
    }

    private void removeConnectFuture() {
        if (this.sendFuture != null) {
            this.sendFuture.onSuccess(null).onFailure(null);
            this.sendFuture = null;
        }
    }
}

