package cool.scx.socket;

public class ScxSocketOptions {

    private int pingInterval;

    private int pingTimeout;

    private int seqIDClearTimeout;

    public ScxSocketOptions() {
        this.pingInterval = 1000 * 5;
        this.pingTimeout = 1000 * 5;
        this.seqIDClearTimeout = 1000 * 60 * 10;
    }

    public final int getPingInterval() {
        return pingInterval;
    }

    public final ScxSocketOptions setPingInterval(int pingInterval) {
        this.pingInterval = pingInterval;
        return this;
    }

    public final int getPingTimeout() {
        return pingTimeout;
    }

    public final ScxSocketOptions setPingTimeout(int pingTimeout) {
        this.pingTimeout = pingTimeout;
        return this;
    }

    public int getSeqIDClearTimeout() {
        return seqIDClearTimeout;
    }

    public ScxSocketOptions setSeqIDClearTimeout(int seqIDClearTimeout) {
        this.seqIDClearTimeout = seqIDClearTimeout;
        return this;
    }
}
