/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.EventManager;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketOptions;
import cool.scx.socket.SendOptions;
import cool.scx.socket.SendTask;
import cool.scx.util.StringUtils;
import io.vertx.core.http.WebSocketBase;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ScxSocket
extends EventManager {
    protected final ConcurrentMap<Long, SendTask> sendTaskMap = new ConcurrentHashMap<Long, SendTask>();

    public ScxSocket(ScxSocketOptions options, String clientID) {
        super(options, clientID);
    }

    @Override
    protected void send(ScxSocketFrame socketFrame, SendOptions options) {
        SendTask sendTask = new SendTask(socketFrame, options, this);
        this.sendTaskMap.put(socketFrame.seq_id, sendTask);
        sendTask.start();
    }

    private void startAllSendTask() {
        for (SendTask value : this.sendTaskMap.values()) {
            value.start();
        }
    }

    private void cancelAllResendTask() {
        for (SendTask value : this.sendTaskMap.values()) {
            value.cancelResend();
        }
    }

    private void startAllSendTaskAsync() {
        Thread.ofVirtual().start(this::startAllSendTask);
    }

    private void cancelAllResendTaskAsync() {
        Thread.ofVirtual().start(this::cancelAllResendTask);
    }

    @Override
    protected void doMessage(ScxSocketFrame socketFrame) {
        if (socketFrame.need_ack) {
            this.sendAck(socketFrame.seq_id);
        }
        if (StringUtils.isBlank((String)socketFrame.event_name)) {
            this.callOnMessageWithCheckDuplicateAsync(socketFrame);
        } else {
            this.callOnEventWithCheckDuplicateAsync(socketFrame);
        }
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230\u6d88\u606f : {1}", this.clientID, socketFrame.toJson());
        }
    }

    @Override
    protected void doResponse(ScxSocketFrame socketFrame) {
        if (socketFrame.need_ack) {
            this.sendAck(socketFrame.seq_id);
        }
        this.callResponseCallbackAsync(socketFrame);
    }

    @Override
    protected void doAck(ScxSocketFrame ackFrame) {
        SendTask sendTask = (SendTask)this.sendTaskMap.get(ackFrame.ack_id);
        if (sendTask != null) {
            sendTask.clear();
        }
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230 ACK : {1}", this.clientID, ackFrame.toJson());
        }
    }

    @Override
    protected void doClose(Void v) {
        this.close();
        this.callOnClose(v);
    }

    @Override
    protected void doError(Throwable e) {
        this.close();
        this.callOnError(e);
    }

    void start(WebSocketBase webSocket) {
        this.close();
        this.bind(webSocket);
        this.startAllSendTask();
        this.duplicateFrameChecker.startAllClearTask();
    }

    public void close() {
        this.removeBind();
        this.closeWebSocket();
        this.cancelAllResendTask();
        this.duplicateFrameChecker.cancelAllClearTask();
    }
}

