/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.FrameCreator;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketOptions;
import cool.scx.socket.SendOptions;
import io.vertx.core.Future;
import io.vertx.core.http.WebSocketBase;
import java.util.function.Consumer;

public abstract class ScxSocketBase {
    protected final System.Logger logger = System.getLogger(this.getClass().getName());
    protected final ScxSocketOptions options;
    protected final String clientID;
    private final FrameCreator frameCreator;
    protected WebSocketBase webSocket;

    protected ScxSocketBase(ScxSocketOptions options, String clientID) {
        this.options = options;
        this.clientID = clientID;
        this.frameCreator = new FrameCreator();
    }

    public String clientID() {
        return this.clientID;
    }

    public void send(String content) {
        this.send(this.frameCreator.createMessageFrame(content, SendOptions.DEFAULT_SEND_OPTIONS), SendOptions.DEFAULT_SEND_OPTIONS);
    }

    public void send(String content, SendOptions options) {
        this.send(this.frameCreator.createMessageFrame(content, options), options);
    }

    public void sendEvent(String eventName, String data) {
        this.send(this.frameCreator.createEventFrame(eventName, data, SendOptions.DEFAULT_SEND_OPTIONS), SendOptions.DEFAULT_SEND_OPTIONS);
    }

    public void sendEvent(String eventName, String data, SendOptions options) {
        this.send(this.frameCreator.createEventFrame(eventName, data, options), options);
    }

    public void sendEvent(String eventName, String data, Consumer<String> responseCallback) {
        ScxSocketFrame eventFrame = this.frameCreator.createRequestFrame(eventName, data, SendOptions.DEFAULT_SEND_OPTIONS);
        this.setResponseCallback(eventFrame, responseCallback);
        this.send(eventFrame, SendOptions.DEFAULT_SEND_OPTIONS);
    }

    public void sendEvent(String eventName, String data, Consumer<String> responseCallback, SendOptions options) {
        ScxSocketFrame eventFrame = this.frameCreator.createRequestFrame(eventName, data, options);
        this.setResponseCallback(eventFrame, responseCallback);
        this.send(eventFrame, options);
    }

    protected void sendResponse(long ack_id, String responseData) {
        this.send(this.frameCreator.createResponseFrame(ack_id, responseData, SendOptions.DEFAULT_SEND_OPTIONS), SendOptions.DEFAULT_SEND_OPTIONS);
    }

    protected void sendAck(long ack_id) {
        ScxSocketFrame ackFrame = FrameCreator.createAckFrame(ack_id);
        Future sendAckFuture = this.webSocket.writeTextMessage(ackFrame.toJson());
        sendAckFuture.onSuccess(v -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 ACK \u6210\u529f : {1}", this.clientID, ackFrame.toJson());
            }
        }).onFailure(c -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 ACK \u5931\u8d25 : {1}", this.clientID, ackFrame.toJson(), c);
            }
        });
    }

    protected void bind(WebSocketBase webSocket) {
        this.webSocket = webSocket;
        this.webSocket.textMessageHandler(t -> this.doSocketFrame(ScxSocketFrame.fromJson(t)));
        this.webSocket.closeHandler(this::doClose);
        this.webSocket.exceptionHandler(this::doError);
    }

    protected void removeBind() {
        if (this.webSocket != null && !this.webSocket.isClosed()) {
            this.webSocket.textMessageHandler(null);
            this.webSocket.closeHandler(null);
            this.webSocket.exceptionHandler(null);
        }
    }

    protected void doSocketFrame(ScxSocketFrame socketFrame) {
        switch (socketFrame.type) {
            case 0: {
                this.doMessage(socketFrame);
                break;
            }
            case 1: {
                this.doResponse(socketFrame);
                break;
            }
            case 2: {
                this.doAck(socketFrame);
            }
        }
    }

    protected void closeWebSocket() {
        if (this.webSocket != null && !this.webSocket.isClosed()) {
            this.webSocket.close();
        }
    }

    public boolean isClosed() {
        return this.webSocket == null || this.webSocket.isClosed();
    }

    protected abstract void send(ScxSocketFrame var1, SendOptions var2);

    protected abstract void setResponseCallback(ScxSocketFrame var1, Consumer<String> var2);

    protected abstract void doMessage(ScxSocketFrame var1);

    protected abstract void doResponse(ScxSocketFrame var1);

    protected abstract void doAck(ScxSocketFrame var1);

    protected abstract void doClose(Void var1);

    protected abstract void doError(Throwable var1);
}

