/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.ScxSocketClientOptions;
import cool.scx.socket.ScxSocketHelper;
import cool.scx.socket.TypeConverter;
import cool.scx.util.RandomUtils;
import cool.scx.util.ScxFuture;
import io.netty.util.Timeout;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketConnectOptions;
import java.util.function.Consumer;

public final class ScxSocketClient
extends TypeConverter {
    private final WebSocketConnectOptions connectOptions;
    private final WebSocketClient webSocketClient;
    private final ScxSocketClientOptions clientOptions;
    private Timeout reconnectTimeout;
    private ScxFuture<WebSocket> connectFuture;
    private Consumer<Void> onOpen;

    public ScxSocketClient(String uri, WebSocketClient webSocketClient, String clientID, ScxSocketClientOptions clientOptions) {
        super(clientOptions, clientID);
        this.clientOptions = clientOptions;
        this.webSocketClient = webSocketClient;
        this.connectOptions = ScxSocketHelper.initConnectOptions(uri, this.clientID);
    }

    public ScxSocketClient(String uri, WebSocketClient webSocketClient, ScxSocketClientOptions options) {
        this(uri, webSocketClient, RandomUtils.randomUUID(), options);
    }

    public ScxSocketClient(String uri, WebSocketClient webSocketClient, String clientID) {
        this(uri, webSocketClient, clientID, new ScxSocketClientOptions());
    }

    public ScxSocketClient(String uri, WebSocketClient webSocketClient) {
        this(uri, webSocketClient, RandomUtils.randomUUID(), new ScxSocketClientOptions());
    }

    private void removeConnectFuture() {
        if (this.connectFuture != null) {
            this.connectFuture.onSuccess(null).onFailure(null);
            this.connectFuture = null;
        }
    }

    public void onOpen(Consumer<Void> onOpen) {
        this.onOpen = onOpen;
    }

    private void cancelReconnect() {
        if (this.reconnectTimeout != null) {
            this.reconnectTimeout.cancel();
            this.reconnectTimeout = null;
        }
    }

    public void connect() {
        if (this.connectFuture != null && !this.connectFuture.isComplete()) {
            return;
        }
        this.close();
        this.connectFuture = new ScxFuture(this.webSocketClient.connect(this.connectOptions));
        this.connectFuture.onSuccess(webSocket -> {
            this.start((WebSocketBase)webSocket);
            this.doOpen();
        }).onFailure(v -> this.reconnect());
    }

    private void doOpen() {
        this.callOnOpen(null);
    }

    @Override
    protected void doClose(Void unused) {
        super.doClose(unused);
        this.connect();
    }

    @Override
    protected void doError(Throwable e) {
        super.doError(e);
        this.connect();
    }

    private void reconnect() {
        if (this.reconnectTimeout != null) {
            return;
        }
        this.logger.log(System.Logger.Level.DEBUG, "WebSocket \u91cd\u8fde\u4e2d... ");
        this.reconnectTimeout = ScxSocketHelper.setTimeout(() -> {
            this.reconnectTimeout = null;
            this.connect();
        }, this.clientOptions.getReconnectTimeout());
    }

    @Override
    public void close() {
        this.removeConnectFuture();
        this.cancelReconnect();
        this.resetCloseOrErrorBind();
        super.close();
    }

    private void resetCloseOrErrorBind() {
        if (this.webSocket != null && !this.webSocket.isClosed()) {
            this.webSocket.closeHandler(x$0 -> super.doClose((Void)x$0));
            this.webSocket.exceptionHandler(x$0 -> super.doError((Throwable)x$0));
        }
    }

    @Override
    protected void doPingTimeout() {
        this.connect();
    }

    private void callOnOpen(Void v) {
        if (this.onOpen != null) {
            this.onOpen.accept(v);
        }
    }

    private void callOnOpenAsync(Void v) {
        if (this.onOpen != null) {
            Thread.ofVirtual().start(() -> this.onOpen.accept(v));
        }
    }
}

