/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.DuplicateFrameChecker;
import cool.scx.socket.EventHandler;
import cool.scx.socket.FrameCreator;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketOptions;
import cool.scx.socket.ScxSocketRequest;
import cool.scx.socket.SendOptions;
import cool.scx.socket.SendTask;
import cool.scx.util.StringUtils;
import io.vertx.core.Future;
import io.vertx.core.http.WebSocketBase;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class ScxSocket {
    protected final ConcurrentMap<Long, SendTask> sendTaskMap;
    protected final System.Logger logger = System.getLogger(this.getClass().getName());
    protected final ScxSocketOptions options;
    protected final String clientID;
    protected final DuplicateFrameChecker duplicateFrameChecker;
    private final FrameCreator frameCreator;
    private final ConcurrentMap<String, EventHandler> eventHandlerMap;
    private final ConcurrentMap<Long, Consumer<String>> responseCallbackMap;
    protected WebSocketBase webSocket;
    private Consumer<String> onMessage;
    private Consumer<Void> onClose;
    private Consumer<Throwable> onError;

    public ScxSocket(ScxSocketOptions options, String clientID) {
        this.sendTaskMap = new ConcurrentHashMap<Long, SendTask>();
        this.duplicateFrameChecker = new DuplicateFrameChecker(options.getSeqIDClearTimeout());
        this.eventHandlerMap = new ConcurrentHashMap<String, EventHandler>();
        this.responseCallbackMap = new ConcurrentHashMap<Long, Consumer<String>>();
        this.options = options;
        this.clientID = clientID;
        this.frameCreator = new FrameCreator();
    }

    public ScxSocket(ScxSocket scxSocket) {
        this.sendTaskMap = scxSocket.sendTaskMap;
        this.duplicateFrameChecker = scxSocket.duplicateFrameChecker;
        this.eventHandlerMap = scxSocket.eventHandlerMap;
        this.responseCallbackMap = scxSocket.responseCallbackMap;
        this.options = scxSocket.options;
        this.clientID = scxSocket.clientID;
        this.frameCreator = scxSocket.frameCreator;
        this.onMessage = scxSocket.onMessage;
        this.onClose = scxSocket.onClose;
        this.onError = scxSocket.onError;
    }

    protected void send(ScxSocketFrame socketFrame, SendOptions options) {
        SendTask sendTask = new SendTask(socketFrame, options, this);
        this.sendTaskMap.put(socketFrame.seq_id, sendTask);
        sendTask.start(this);
    }

    private void startAllSendTask() {
        for (SendTask value : this.sendTaskMap.values()) {
            value.start(this);
        }
    }

    private void cancelAllResendTask() {
        for (SendTask value : this.sendTaskMap.values()) {
            value.cancelResend();
        }
    }

    private void startAllSendTaskAsync() {
        Thread.ofVirtual().start(this::startAllSendTask);
    }

    private void cancelAllResendTaskAsync() {
        Thread.ofVirtual().start(this::cancelAllResendTask);
    }

    protected void doMessage(ScxSocketFrame socketFrame) {
        if (socketFrame.need_ack) {
            this.sendAck(socketFrame.seq_id);
        }
        if (StringUtils.isBlank((String)socketFrame.event_name)) {
            this.callOnMessageWithCheckDuplicateAsync(socketFrame);
        } else {
            this.callOnEventWithCheckDuplicateAsync(socketFrame);
        }
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230\u6d88\u606f : {1}", this.clientID, socketFrame.toJson());
        }
    }

    protected void doResponse(ScxSocketFrame socketFrame) {
        if (socketFrame.need_ack) {
            this.sendAck(socketFrame.seq_id);
        }
        this.callResponseCallbackAsync(socketFrame);
    }

    protected void doAck(ScxSocketFrame ackFrame) {
        SendTask sendTask = (SendTask)this.sendTaskMap.get(ackFrame.ack_id);
        if (sendTask != null) {
            sendTask.clear(this);
        }
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230 ACK : {1}", this.clientID, ackFrame.toJson());
        }
    }

    protected void doClose(Void v) {
        this.close();
        this.callOnClose(v);
    }

    protected void doError(Throwable e) {
        this.close();
        this.callOnError(e);
    }

    void start(WebSocketBase webSocket) {
        this.close();
        this.bind(webSocket);
        this.startAllSendTask();
        this.duplicateFrameChecker.startAllClearTask();
    }

    public void close() {
        this.closeWebSocket();
        this.cancelAllResendTask();
        this.duplicateFrameChecker.cancelAllClearTask();
    }

    public String clientID() {
        return this.clientID;
    }

    public void send(String content) {
        this.send(this.frameCreator.createMessageFrame(content, SendOptions.DEFAULT_SEND_OPTIONS), SendOptions.DEFAULT_SEND_OPTIONS);
    }

    public void send(String content, SendOptions options) {
        this.send(this.frameCreator.createMessageFrame(content, options), options);
    }

    public void sendEvent(String eventName, String data) {
        this.send(this.frameCreator.createEventFrame(eventName, data, SendOptions.DEFAULT_SEND_OPTIONS), SendOptions.DEFAULT_SEND_OPTIONS);
    }

    public void sendEvent(String eventName, String data, SendOptions options) {
        this.send(this.frameCreator.createEventFrame(eventName, data, options), options);
    }

    public void sendEvent(String eventName, String data, Consumer<String> responseCallback) {
        ScxSocketFrame eventFrame = this.frameCreator.createRequestFrame(eventName, data, SendOptions.DEFAULT_SEND_OPTIONS);
        this.setResponseCallback(eventFrame, responseCallback);
        this.send(eventFrame, SendOptions.DEFAULT_SEND_OPTIONS);
    }

    public void sendEvent(String eventName, String data, Consumer<String> responseCallback, SendOptions options) {
        ScxSocketFrame eventFrame = this.frameCreator.createRequestFrame(eventName, data, options);
        this.setResponseCallback(eventFrame, responseCallback);
        this.send(eventFrame, options);
    }

    protected void sendResponse(long ack_id, String responseData) {
        this.send(this.frameCreator.createResponseFrame(ack_id, responseData, SendOptions.DEFAULT_SEND_OPTIONS), SendOptions.DEFAULT_SEND_OPTIONS);
    }

    protected void sendAck(long ack_id) {
        ScxSocketFrame ackFrame = FrameCreator.createAckFrame(ack_id);
        Future sendAckFuture = this.webSocket.writeTextMessage(ackFrame.toJson());
        sendAckFuture.onSuccess(v -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 ACK \u6210\u529f : {1}", this.clientID, ackFrame.toJson());
            }
        }).onFailure(c -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 ACK \u5931\u8d25 : {1}", this.clientID, ackFrame.toJson(), c);
            }
        });
    }

    protected void bind(WebSocketBase webSocket) {
        this.webSocket = webSocket;
        this.webSocket.textMessageHandler(t -> this.doSocketFrame(ScxSocketFrame.fromJson(t)));
        this.webSocket.closeHandler(this::doClose);
        this.webSocket.exceptionHandler(this::doError);
    }

    protected void doSocketFrame(ScxSocketFrame socketFrame) {
        switch (socketFrame.type) {
            case 0: {
                this.doMessage(socketFrame);
                break;
            }
            case 1: {
                this.doResponse(socketFrame);
                break;
            }
            case 2: {
                this.doAck(socketFrame);
            }
        }
    }

    protected void closeWebSocket() {
        if (this.webSocket != null && !this.webSocket.isClosed()) {
            this.webSocket.close().onSuccess(c -> {});
        }
    }

    public boolean isClosed() {
        return this.webSocket == null || this.webSocket.isClosed();
    }

    public final void onMessage(Consumer<String> onMessage) {
        this.onMessage = onMessage;
    }

    public final void onClose(Consumer<Void> onClose) {
        this.onClose = onClose;
        if (this.webSocket != null) {
            this.webSocket.closeHandler(this::doClose);
        }
    }

    public final void onError(Consumer<Throwable> onError) {
        this.onError = onError;
        if (this.webSocket != null) {
            this.webSocket.exceptionHandler(this::doError);
        }
    }

    public final void onEvent(String eventName, Consumer<String> onEvent) {
        this.eventHandlerMap.put(eventName, new EventHandler(onEvent));
    }

    public final void onEvent(String eventName, Function<String, String> onEvent) {
        this.eventHandlerMap.put(eventName, new EventHandler(onEvent));
    }

    public final void onEvent(String eventName, BiConsumer<String, ScxSocketRequest> onEvent) {
        this.eventHandlerMap.put(eventName, new EventHandler(onEvent));
    }

    public final void removeEvent(String eventName) {
        this.eventHandlerMap.remove(eventName);
    }

    private void callOnMessage(String message) {
        if (this.onMessage != null) {
            this.onMessage.accept(message);
        }
    }

    protected void callOnClose(Void v) {
        if (this.onClose != null) {
            this.onClose.accept(v);
        }
    }

    protected void callOnError(Throwable e) {
        if (this.onError != null) {
            this.onError.accept(e);
        }
    }

    private void callOnMessageAsync(String message) {
        if (this.onMessage != null) {
            Thread.ofVirtual().start(() -> this.onMessage.accept(message));
        }
    }

    private void callOnCloseAsync(Void v) {
        if (this.onClose != null) {
            Thread.ofVirtual().start(() -> this.onClose.accept(v));
        }
    }

    private void callOnErrorAsync(Throwable e) {
        if (this.onError != null) {
            Thread.ofVirtual().start(() -> this.onError.accept(e));
        }
    }

    protected final void callOnMessageWithCheckDuplicateAsync(ScxSocketFrame socketFrame) {
        if (this.onMessage != null && this.duplicateFrameChecker.checkDuplicate(socketFrame)) {
            Thread.ofVirtual().start(() -> this.onMessage.accept(socketFrame.payload));
        }
    }

    protected final void callOnEventWithCheckDuplicateAsync(ScxSocketFrame socketFrame) {
        EventHandler eventHandler = (EventHandler)this.eventHandlerMap.get(socketFrame.event_name);
        if (eventHandler != null && this.duplicateFrameChecker.checkDuplicate(socketFrame)) {
            Thread.ofVirtual().start(() -> {
                switch (eventHandler.type) {
                    case 0: {
                        Consumer<String> event0 = eventHandler.event0();
                        event0.accept(socketFrame.payload);
                        if (!socketFrame.need_response) break;
                        this.sendResponse(socketFrame.seq_id, null);
                        break;
                    }
                    case 1: {
                        Function<String, String> event1 = eventHandler.event1();
                        String responseData = event1.apply(socketFrame.payload);
                        if (!socketFrame.need_response) break;
                        this.sendResponse(socketFrame.seq_id, responseData);
                        break;
                    }
                    case 2: {
                        BiConsumer<String, ScxSocketRequest> event2 = eventHandler.event2();
                        if (socketFrame.need_response) {
                            ScxSocketRequest scxSocketRequest = new ScxSocketRequest(this, socketFrame.seq_id);
                            event2.accept(socketFrame.payload, scxSocketRequest);
                            break;
                        }
                        event2.accept(socketFrame.payload, null);
                    }
                }
            });
        }
    }

    protected final void setResponseCallback(ScxSocketFrame socketFrame, Consumer<String> responseCallback) {
        this.responseCallbackMap.put(socketFrame.seq_id, responseCallback);
    }

    protected void callResponseCallback(ScxSocketFrame socketFrame) {
        Consumer responseCallback = (Consumer)this.responseCallbackMap.remove(socketFrame.ack_id);
        if (responseCallback != null) {
            responseCallback.accept(socketFrame.payload);
        }
    }

    protected void callResponseCallbackAsync(ScxSocketFrame socketFrame) {
        Consumer responseCallback = (Consumer)this.responseCallbackMap.remove(socketFrame.ack_id);
        if (responseCallback != null) {
            Thread.ofVirtual().start(() -> responseCallback.accept(socketFrame.payload));
        }
    }
}

