/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import cool.scx.socket.PingPongManager;
import cool.scx.socket.ScxSocketOptions;
import cool.scx.socket.ScxSocketRequest;
import cool.scx.socket.SendOptions;
import cool.scx.util.ObjectUtils;
import cool.scx.util.ScxExceptionHelper;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class TypeConverter
extends PingPongManager {
    private static final JsonMapper jsonMapper = ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]);

    public TypeConverter(ScxSocketOptions options, String clientID) {
        super(options, clientID);
    }

    public TypeConverter(TypeConverter typeConverter) {
        super(typeConverter);
    }

    private static String toJson(Object data) {
        return (String)ScxExceptionHelper.wrap(() -> jsonMapper.writeValueAsString(data));
    }

    private static <T> T fromJson(String json, Class<T> tClass) {
        return (T)ScxExceptionHelper.wrap(() -> jsonMapper.readValue(json, tClass));
    }

    private static <T> T fromJson(String json, TypeReference<T> valueTypeRef) {
        return (T)ScxExceptionHelper.wrap(() -> jsonMapper.readValue(json, valueTypeRef));
    }

    public void send(Object data) {
        super.send(TypeConverter.toJson(data));
    }

    public void send(Object data, SendOptions options) {
        super.send(TypeConverter.toJson(data), options);
    }

    public void sendEvent(String eventName, Object data) {
        super.sendEvent(eventName, TypeConverter.toJson(data));
    }

    public void sendEvent(String eventName, Object data, SendOptions options) {
        super.sendEvent(eventName, TypeConverter.toJson(data), options);
    }

    public void sendEvent(String eventName, Object data, Consumer<String> responseCallback) {
        super.sendEvent(eventName, TypeConverter.toJson(data), responseCallback);
    }

    public void sendEvent(String eventName, Object data, Consumer<String> responseCallback, SendOptions options) {
        super.sendEvent(eventName, TypeConverter.toJson(data), responseCallback, options);
    }

    public <T> void sendEvent(String eventName, Object data, Consumer<T> responseCallback, Class<T> tClass) {
        super.sendEvent(eventName, TypeConverter.toJson(data), (String s) -> responseCallback.accept(TypeConverter.fromJson(s, tClass)));
    }

    public <T> void sendEvent(String eventName, Object data, Consumer<T> responseCallback, SendOptions options, Class<T> tClass) {
        super.sendEvent(eventName, TypeConverter.toJson(data), (String s) -> responseCallback.accept(TypeConverter.fromJson(s, tClass)), options);
    }

    public <T> void sendEvent(String eventName, Object data, Consumer<T> responseCallback, TypeReference<T> tClass) {
        super.sendEvent(eventName, TypeConverter.toJson(data), (String s) -> responseCallback.accept(TypeConverter.fromJson(s, tClass)));
    }

    public <T> void sendEvent(String eventName, Object data, Consumer<T> responseCallback, SendOptions options, TypeReference<T> tClass) {
        super.sendEvent(eventName, TypeConverter.toJson(data), (String s) -> responseCallback.accept(TypeConverter.fromJson(s, tClass)), options);
    }

    public <T> void onEvent(String eventName, Consumer<T> onEvent, Class<T> tClass) {
        super.onEvent(eventName, (String s) -> onEvent.accept(TypeConverter.fromJson(s, tClass)));
    }

    public <T> void onEvent(String eventName, Function<T, ?> onEvent, Class<T> tClass) {
        super.onEvent(eventName, (String s) -> {
            Object data = onEvent.apply(TypeConverter.fromJson(s, tClass));
            if (data instanceof String) {
                String str = (String)data;
                return str;
            }
            return TypeConverter.toJson(data);
        });
    }

    public <T> void onEvent(String eventName, Consumer<T> onEvent, TypeReference<T> tClass) {
        super.onEvent(eventName, (String s) -> onEvent.accept(TypeConverter.fromJson(s, tClass)));
    }

    public <T> void onEvent(String eventName, Function<T, ?> onEvent, TypeReference<T> tClass) {
        super.onEvent(eventName, (String s) -> {
            Object data = onEvent.apply(TypeConverter.fromJson(s, tClass));
            if (data instanceof String) {
                String str = (String)data;
                return str;
            }
            return TypeConverter.toJson(data);
        });
    }

    public <T> void onEvent(String eventName, BiConsumer<T, TypeRequest> onEvent, Class<T> tClass) {
        super.onEvent(eventName, (String s, ScxSocketRequest r) -> onEvent.accept(TypeConverter.fromJson(s, tClass), new TypeRequest((ScxSocketRequest)r)));
    }

    public <T> void onEvent(String eventName, BiConsumer<T, TypeRequest> onEvent, TypeReference<T> tClass) {
        super.onEvent(eventName, (String s, ScxSocketRequest r) -> onEvent.accept(TypeConverter.fromJson(s, tClass), new TypeRequest((ScxSocketRequest)r)));
    }

    public static class TypeRequest {
        private final ScxSocketRequest request;

        public TypeRequest(ScxSocketRequest r) {
            this.request = r;
        }

        public void response(String payload) {
            this.request.response(payload);
        }

        public void response(Object payload) {
            this.request.response(TypeConverter.toJson(payload));
        }
    }
}

