/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket.sender;

import cool.scx.socket.core.ScxSocket;
import cool.scx.socket.frame.ScxSocketFrame;
import cool.scx.socket.sender.SendOptions;
import cool.scx.socket.sender.SendTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FrameSender {
    final ConcurrentMap<Long, SendTask> sendTaskMap = new ConcurrentHashMap<Long, SendTask>();

    public void clearSendTask(ScxSocketFrame ackFrame) {
        SendTask sendTask = (SendTask)this.sendTaskMap.get(ackFrame.ack_id);
        if (sendTask != null) {
            sendTask.clear();
        }
    }

    public void send(ScxSocketFrame socketFrame, SendOptions options, ScxSocket scxSocket) {
        SendTask sendTask = new SendTask(socketFrame, options, this);
        this.sendTaskMap.put(socketFrame.seq_id, sendTask);
        sendTask.start(scxSocket);
    }

    public void startAllSendTask(ScxSocket scxSocket) {
        for (SendTask value : this.sendTaskMap.values()) {
            value.start(scxSocket);
        }
    }

    public void cancelAllResendTask() {
        for (SendTask value : this.sendTaskMap.values()) {
            value.cancelResend();
        }
    }

    private void startAllSendTaskAsync(ScxSocket scxSocket) {
        Thread.ofVirtual().start(() -> this.startAllSendTask(scxSocket));
    }

    private void cancelAllResendTaskAsync() {
        Thread.ofVirtual().start(this::cancelAllResendTask);
    }
}

