/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.ScxSocketServer;
import cool.scx.socket.ScxSocketServerOptions;
import cool.scx.socket.helper.Helper;
import cool.scx.socket.ping_pong.PingPongManager;
import io.netty.util.Timeout;
import io.vertx.core.http.WebSocketBase;

public final class ScxSocketClientConnect
extends PingPongManager {
    private final ScxSocketServer scxSocketServer;
    private final ScxSocketServerOptions serverOptions;
    private Timeout removeClosedClientTimeout;

    public ScxSocketClientConnect(String clientID, ScxSocketServerOptions serverOptions, ScxSocketServer scxSocketServer) {
        super(serverOptions, clientID);
        this.serverOptions = serverOptions;
        this.scxSocketServer = scxSocketServer;
    }

    public ScxSocketClientConnect(ScxSocketClientConnect oldClientConnect) {
        super(oldClientConnect);
        this.serverOptions = oldClientConnect.serverOptions;
        this.scxSocketServer = oldClientConnect.scxSocketServer;
    }

    @Override
    protected void start(WebSocketBase webSocket) {
        super.start(webSocket);
        this.cancelRemoveClosedClientTask();
    }

    @Override
    public void close() {
        super.close();
        this.startRemoveClosedClientTask();
    }

    private void startRemoveClosedClientTask() {
        this.cancelRemoveClosedClientTask();
        this.removeClosedClientTimeout = Helper.setTimeout(this::removeClosedClient, this.serverOptions.getRemoveClosedClientTimeout());
    }

    private void cancelRemoveClosedClientTask() {
        if (this.removeClosedClientTimeout != null) {
            this.removeClosedClientTimeout.cancel();
            this.removeClosedClientTimeout = null;
        }
    }

    private void removeClosedClient() {
        this.scxSocketServer.clientConnectMap.remove(this.clientID);
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u5ba2\u6237\u7aef\u8d85\u65f6\u672a\u8fde\u63a5 \u5df2\u79fb\u9664", this.clientID);
        }
    }

    @Override
    protected void startPing() {
    }

    @Override
    protected void doPingTimeout() {
        this.close();
    }
}

